/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SelectNextPatchSetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent aEvent) {
        block11: {
            try {
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (!(editor instanceof CompareEditor)) break block11;
                String commandName = aEvent.getCommand().getId();
                boolean isLeftSide = commandName.contains("selectLeftPatchSet");
                GerritMultipleInput input = (GerritMultipleInput)((CompareEditor)editor).getEditorInput();
                ArrayList revisions = new ArrayList(input.getChangeInfo().getRevisions().values());
                revisions.sort((o2, o1) -> o1.get_number() - o2.get_number());
                LinkedHashMap<String, String> patchNumber = new LinkedHashMap<String, String>();
                ListIterator iter = revisions.listIterator();
                while (iter.hasNext()) {
                    RevisionInfo element = (RevisionInfo)iter.next();
                    patchNumber.put(new Integer(element.get_number()).toString(), element.getId());
                }
                patchNumber.put("WORKSPACE", "WORKSPACE");
                if (isLeftSide) {
                    patchNumber.put("BASE", "BASE");
                }
                Iterator itr = patchNumber.entrySet().iterator();
                Iterator first = patchNumber.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (isLeftSide && ((String)entry.getValue()).compareTo(input.getLeftSide()) == 0) {
                        if (itr.hasNext()) {
                            entry = itr.next();
                            input.switchInputs((String)entry.getValue(), null);
                        } else {
                            entry = first.next();
                            input.switchInputs((String)entry.getValue(), null);
                        }
                    } else {
                        if (isLeftSide || ((String)entry.getValue()).compareTo(input.getRightSide()) != 0) continue;
                        if (itr.hasNext()) {
                            entry = itr.next();
                            input.switchInputs(null, (String)entry.getValue());
                        } else {
                            entry = first.next();
                            input.switchInputs(null, (String)entry.getValue());
                        }
                    }
                    break;
                }
            }
            catch (Throwable throwable) {}
        }
        return Status.OK_STATUS;
    }
}

