/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;

public class ClearReviewedFlag {
    private GerritClient fGerritClient;
    private List<FileInfo> fListFilesInfo;

    public ClearReviewedFlag(GerritClient gerritClient, List<FileInfo> listFilesInfo) {
        this.fGerritClient = gerritClient;
        this.fListFilesInfo = listFilesInfo;
    }

    public void removeCheckMark() {
        ListIterator<FileInfo> it = this.fListFilesInfo.listIterator();
        while (it.hasNext()) {
            this.clearFlag((FileInfo)it.next());
        }
    }

    private void clearFlag(FileInfo fileInfo) {
        CompletableFuture.runAsync(() -> {
            if (fileInfo.isReviewed()) {
                QueryHelpers.markAsNotReviewed(this.fGerritClient, fileInfo);
            }
        });
    }
}

