/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.eclipse.egf.common.ui.field.DomainFieldEditor;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.adapters.BooleanFieldEditorAdapter;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractDomainWizardPage;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class NewDomainWizardPage
extends AbstractDomainWizardPage {
    private ValidatingStringFieldEditor _packageNameFieldEditor;
    private static final int GROUP_NUM_COLUMNS = 3;
    private Composite _group;
    private BooleanFieldEditorAdapter _creationFieldEditor;

    public NewDomainWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public NewDomainWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        this._group = FieldEditorHelper.createGroup((Composite)parent_p, null, (int)0, (int)3);
        this.createDomainCreationCheckBox(this._group);
        this.createPackageNameFieldEditor(this._group);
        this.createDomainFileFieldEditor(this._group);
        this.handlePageLayout(parent_p);
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)this._packageNameFieldEditor.getTextControl().getParent(), (FieldEditor)this._packageNameFieldEditor, (int)3);
        GridData gd = (GridData)this._packageNameFieldEditor.getLabel().getLayoutData();
        gd.horizontalIndent = 10;
        IFieldEditor domainFileNameFieldEditor = this.getDomainFileNameFieldEditor();
        FieldEditorHelper.layoutFieldEditor((Composite)domainFileNameFieldEditor.getValueControl().getParent(), (FieldEditor)((FieldEditor)domainFileNameFieldEditor), (int)3);
        gd = new GridData();
        domainFileNameFieldEditor.getLabel().setLayoutData((Object)gd);
        gd.horizontalIndent = 10;
        FieldEditorHelper.layoutFieldEditor((Composite)this._creationFieldEditor.getValueControl().getParent(), (FieldEditor)this._creationFieldEditor, (int)3);
    }

    private BooleanFieldEditorAdapter createDomainCreationCheckBox(Composite group_p) {
        this._creationFieldEditor = FieldEditorHelper.createCheckBoxFieldEditor((Composite)group_p, (DialogPage)this, (String)Messages.NewDomainWizardPage_CreateDomain_Title, (String)Messages.NewDomainWizardPage_CreateDomain_Tooltip, (boolean)true, (int)0, (int)0, (boolean)this.isReadOnly());
        ((Button)this._creationFieldEditor.getValueControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                boolean isCreatingDomain = ((Button)event_p.widget).getSelection();
                Text packageNameText = (Text)NewDomainWizardPage.this._packageNameFieldEditor.getValueControl();
                packageNameText.setEditable(isCreatingDomain);
                IFieldEditor domainFileNameFieldEditor = NewDomainWizardPage.this.getDomainFileNameFieldEditor();
                domainFileNameFieldEditor.getHelperControl().setEnabled(!isCreatingDomain);
                if (isCreatingDomain) {
                    ((Text)domainFileNameFieldEditor.getValueControl()).setText(NewDomainWizardPage.this.getDefaultDomainFilePath());
                } else {
                    packageNameText.setText("");
                }
                NewDomainWizardPage.this.getCompleteStatus();
            }
        });
        return this._creationFieldEditor;
    }

    protected void createDomainFileFieldEditor(Composite parent_p) {
        super.createDomainFileFieldEditor(parent_p);
        DomainFieldEditor fieldEditor = (DomainFieldEditor)this.getDomainFileNameFieldEditor();
        fieldEditor.getHelperControl().setEnabled(false);
        Text domainPath = fieldEditor.getTextControl(parent_p);
        domainPath.setText(this.getDefaultDomainFilePath());
        fieldEditor.isValid(true);
    }

    private void createPackageNameFieldEditor(Composite parent_p) {
        this._packageNameFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.NewDomainWizardPage_Package_Title, (String)Messages.NewDomainWizardPage_Package_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(Messages.NewDomainWizardPage_Package_ErrorMessage), (boolean)this.isReadOnly());
        this._packageNameFieldEditor.isValid(true);
        Text packageNameText = this._packageNameFieldEditor.getTextControl();
        packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                NewDomainWizardPage.this.updateButtons();
            }
        });
    }

    protected boolean getCompleteStatus() {
        boolean result = false;
        if (this._creationFieldEditor.getBooleanValue()) {
            IFieldEditor[] fieldEditors = new IFieldEditor[]{this._packageNameFieldEditor};
            result = this.handleFieldEditorValidation(fieldEditors);
        } else {
            result = this.isDomainSelectedExist();
            String errorMessage = null;
            if (!result) {
                errorMessage = Messages.NewDomainWizardPage_Domain_ErrorMessage;
            }
            this.setErrorMessage(errorMessage);
        }
        return result;
    }

    protected String getPageTitle() {
        return Messages.DomainWizardPage_Title;
    }

    public String getRootPackage() {
        return this._packageNameFieldEditor.getStringValue();
    }
}

