/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class JavaHelper {
    public static boolean deleteJavaClass(IJavaProject javaProject_p, IPath resourcePath_p, boolean deleteParent_p) {
        if (javaProject_p == null || resourcePath_p == null) {
            return false;
        }
        IFolder sourceFolder = JavaHelper.getJavaSourceFolder(javaProject_p, resourcePath_p);
        if (sourceFolder == null) {
            return false;
        }
        IResource resource = sourceFolder.findMember(resourcePath_p);
        if (resource == null || !(resource instanceof IFile)) {
            return false;
        }
        if (!FileHelper.deleteResource(resource)) {
            return false;
        }
        if (deleteParent_p) {
            IContainer container = (IContainer)sourceFolder.findMember(resourcePath_p.removeLastSegments(1));
            while (!container.equals((Object)sourceFolder)) {
                try {
                    IResource[] members = container.members();
                    if (members != null && members.length != 0 || !FileHelper.deleteResource((IResource)container)) break;
                    container = container.getParent();
                }
                catch (CoreException coreException) {
                    break;
                }
            }
        }
        return true;
    }

    public static IFile getJavaSourceFile(IJavaProject javaProject_p, IPath path_p) {
        if (javaProject_p == null || path_p == null) {
            return null;
        }
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject_p.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                IResource sourceFolder;
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && (sourceFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(classpathEntry.getPath())) != null && sourceFolder instanceof IFolder && (resource = ((IFolder)sourceFolder).findMember(path_p)) != null && resource instanceof IFile) {
                    return (IFile)resource;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IFolder getJavaSourceFolder(IJavaProject javaProject_p, IPath path_p) {
        if (javaProject_p == null || path_p == null) {
            return null;
        }
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject_p.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                IResource sourceFolder;
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && (sourceFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(classpathEntry.getPath())) != null && sourceFolder instanceof IFolder && (resource = ((IFolder)sourceFolder).findMember(path_p)) != null) {
                    return (IFolder)sourceFolder;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }
}

