/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.activator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.StatusHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIActivator
extends AbstractUIPlugin {
    private static final String ICONS_PATH = "$nl$/icons/";

    public static Display getWorkbenchDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public void log(Throwable t) {
        this.log(this.newErrorStatus(t.getMessage(), t));
    }

    public IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, this.getPluginID(), 0, message, exception);
    }

    public void log(String message) {
        this.getLog().log(StatusHelper.newStatus((String)this.getPluginID(), (int)4, (String)message, null));
    }

    public void log(String message, Throwable t) {
        this.log(message, StatusHelper.newStatus((String)this.getPluginID(), (int)4, (String)message, (Throwable)t));
    }

    public void log(Class<?> clazz, String methodName, Throwable t) {
        this.log(NLS.bind((String)"Exception in {0}.{1}: {2}", (Object[])new Object[]{clazz.getName(), methodName, t}), t);
    }

    public void log(IStatus status) {
        this.log(null, status);
    }

    public void log(int severity, String message, Throwable e) {
        this.log((IStatus)new Status(severity, this.getPluginID(), 0, message, e));
    }

    public void log(String message, IStatus status) {
        if (message != null) {
            this.getLog().log(StatusHelper.newStatus((String)this.getPluginID(), (int)4, (String)message, null));
        }
        this.getLog().log(status);
    }

    public ImageDescriptor getImageDescriptor(String key_p) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key_p);
        if (imageDescriptor == null) {
            imageDescriptor = this.createImageDescriptor(key_p);
            imageRegistry.put(key_p, imageDescriptor);
        }
        return imageDescriptor;
    }

    public Image getImage(String key_p) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key_p);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.createImageDescriptor(key_p);
            imageRegistry.put(key_p, imageDescriptor);
            image = imageRegistry.get(key_p);
        }
        return image;
    }

    protected ImageDescriptor createImageDescriptor(String key_p) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getPluginID(), (String)(ICONS_PATH + key_p));
        return imageDescriptor;
    }

    public String getPluginID() {
        return this.getBundle().getSymbolicName();
    }
}

