/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.helper;

import org.eclipse.core.resources.IContainer;
import org.eclipse.egf.common.ui.field.ContextElementFieldEditor;
import org.eclipse.egf.common.ui.field.DomainFieldEditor;
import org.eclipse.egf.common.ui.field.JavaClassFieldEditor;
import org.eclipse.egf.common.ui.field.JavaScopeClassFieldEditor;
import org.eclipse.egf.common.ui.field.WorkspaceFileFieldEditor;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.internal.validators.JavaClassValidator;
import org.eclipse.egf.common.ui.toolkit.adapters.BooleanFieldEditorAdapter;
import org.eclipse.egf.common.ui.toolkit.fields.CRadioGroupFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.CStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEditorHelper {
    public static StyledText createDescriptionFieldEditor(Composite parent_p, String label_p, String tooltip_p, String initialText_p, int numColumns_p, IDocumentListener textModificationListener_p, boolean readOnly_p) {
        Composite textComposite = new Composite(parent_p, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        textComposite.setLayout((Layout)gridLayout);
        GridData textCompositeLayoutData = new GridData(4, 4, true, true);
        textComposite.setLayoutData((Object)textCompositeLayoutData);
        textCompositeLayoutData.horizontalSpan = numColumns_p;
        Label descriptionLabel = new Label(textComposite, 16384);
        descriptionLabel.setText(label_p);
        Document document = new Document();
        if (initialText_p != null) {
            document.set(initialText_p);
        }
        document.addDocumentListener(textModificationListener_p);
        int textViewerStyle = 2882;
        SourceViewer textViewer = new SourceViewer(textComposite, null, readOnly_p ? textViewerStyle | 8 : textViewerStyle);
        textViewer.setDocument((IDocument)document);
        StyledText styledText = textViewer.getTextWidget();
        styledText.setFont(parent_p.getFont());
        GridData styledTextLayoutData = new GridData(4, 4, true, true);
        styledText.setLayoutData((Object)styledTextLayoutData);
        FormHelper.forceControlSize((Control)textComposite, 60, 8);
        return styledText;
    }

    public static BooleanFieldEditorAdapter createCheckBoxFieldEditor(Composite parent_p, DialogPage page_p, String label_p, String labelTooltip_p, boolean initialValue_p, final int horizintalIndent_p, final int verticalIndent_p, final boolean readOnly_p) {
        BooleanFieldEditorAdapter checkBoxFieldEditor = new BooleanFieldEditorAdapter("", label_p, 16384, parent_p){

            protected void doFillIntoGrid(Composite parent__p, int numColumns_p) {
                super.doFillIntoGrid(parent__p, numColumns_p);
                Button checkBox = this.getChangeControl(parent__p);
                checkBox.setEnabled(!readOnly_p);
                GridData gd = (GridData)checkBox.getLayoutData();
                gd.horizontalIndent = horizintalIndent_p;
                gd.verticalIndent = verticalIndent_p;
            }
        };
        checkBoxFieldEditor.setPage(page_p);
        Button checkbox = (Button)checkBoxFieldEditor.getValueControl();
        checkbox.setToolTipText(labelTooltip_p);
        checkbox.setSelection(initialValue_p);
        return checkBoxFieldEditor;
    }

    public static Group createGroup(Composite parent_p, String label_p, int style_p, int numColumns_p) {
        Group group = new Group(parent_p, style_p);
        if (label_p != null) {
            group.setText(label_p);
        }
        group.setFont(parent_p.getFont());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = numColumns_p;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns_p;
        group.setLayoutData((Object)gd);
        return group;
    }

    public static ValidatingStringFieldEditor createStringFieldEditor(Composite parent_p, DialogPage page_p, String label_p, String labelTooltip_p, String textTooltip_p, int textLimit_p, IValidator fieldEditorValidator_p, boolean readOnly_p) {
        ValidatingStringFieldEditor fieldEditor = new ValidatingStringFieldEditor("", label_p, CStringFieldEditor.UNLIMITED, 2, parent_p, readOnly_p ? 2060 : 2052);
        fieldEditor.setPage(page_p);
        fieldEditor.setValidator(fieldEditorValidator_p);
        if (labelTooltip_p != null) {
            Label label = fieldEditor.getLabel();
            label.setToolTipText(labelTooltip_p);
        }
        if (textTooltip_p != null) {
            Text text = fieldEditor.getTextControl();
            text.setToolTipText(textTooltip_p);
        }
        if (textLimit_p != -1) {
            fieldEditor.setTextLimit(textLimit_p);
        }
        return fieldEditor;
    }

    public static CRadioGroupFieldEditor createRadioGroupFieldEditor(Composite parent_p, String title_p, int numColumns_p, String[][] labelAndValues_p, boolean readOnly_p) {
        CRadioGroupFieldEditor group = new CRadioGroupFieldEditor("", title_p, numColumns_p, labelAndValues_p, parent_p, true);
        group.getRadioBoxControl(parent_p).setEnabled(!readOnly_p);
        return group;
    }

    public static JavaScopeClassFieldEditor createJavaScopeClassFieldEditor(Composite parent_p, DialogPage page_p, String title_p, String openTypeDialogTitle_p, IJavaProject javaProject_p, Class<?> classTypeFilter_p, final boolean readOnly_p) {
        JavaScopeClassFieldEditor fieldEditor = new JavaScopeClassFieldEditor(title_p, openTypeDialogTitle_p, parent_p, javaProject_p, classTypeFilter_p){

            protected void doFillIntoGrid(Composite parent__p, int numColumns_p) {
                super.doFillIntoGrid(parent__p, numColumns_p);
                this.getChangeControl(parent__p).setEnabled(!readOnly_p);
            }
        };
        fieldEditor.setPage(page_p);
        fieldEditor.setEmptyStringAllowed(false);
        ((Text)fieldEditor.getValueControl()).setEditable(false);
        return fieldEditor;
    }

    public static JavaClassFieldEditor createJavaClassFieldEditor(Composite parent_p, DialogPage page_p, String title_p, String openTypeDialogTitle_p, ClassLoader classLoader_p, Bundle bundle_p, Class<?> classTypeFilter_p, final boolean readOnly_p) {
        JavaClassFieldEditor fieldEditor = new JavaClassFieldEditor(title_p, openTypeDialogTitle_p, parent_p, classTypeFilter_p){

            protected void doFillIntoGrid(Composite parent__p, int numColumns_p) {
                super.doFillIntoGrid(parent__p, numColumns_p);
                this.getChangeControl(parent__p).setEnabled(!readOnly_p);
            }
        };
        FieldEditorHelper.initializeJavaClassFieldEditor(page_p, classLoader_p, bundle_p, classTypeFilter_p, fieldEditor);
        return fieldEditor;
    }

    public static ContextElementFieldEditor createContextElementFieldEditor(Composite parent_p, DialogPage page_p, String title_p, String openTypeDialogTitle_p, ClassLoader classLoader_p, Bundle bundle_p, Class<?> classTypeFilter_p, final boolean readOnly_p) {
        ContextElementFieldEditor fieldEditor = new ContextElementFieldEditor(title_p, openTypeDialogTitle_p, parent_p, classTypeFilter_p){

            protected void doFillIntoGrid(Composite parent__p, int numColumns_p) {
                super.doFillIntoGrid(parent__p, numColumns_p);
                this.getChangeControl(parent__p).setEnabled(!readOnly_p);
            }
        };
        FieldEditorHelper.initializeJavaClassFieldEditor(page_p, classLoader_p, bundle_p, classTypeFilter_p, fieldEditor);
        return fieldEditor;
    }

    private static void initializeJavaClassFieldEditor(DialogPage page_p, ClassLoader classLoader_p, Bundle bundle_p, Class<?> classTypeFilter_p, JavaClassFieldEditor fieldEditor_p) {
        fieldEditor_p.setPage(page_p);
        fieldEditor_p.setEmptyStringAllowed(false);
        ((Text)fieldEditor_p.getValueControl()).setEditable(false);
        fieldEditor_p.setValidator(new JavaClassValidator(classLoader_p, bundle_p, classTypeFilter_p));
    }

    public static WorkspaceFileFieldEditor createWorkspaceFileEditor(Composite parent_p, String title_p, String openResourceDialogTitle_p, IContainer container_p, String filterExtension_p, final boolean readOnly_p) {
        WorkspaceFileFieldEditor fieldEditor = new WorkspaceFileFieldEditor(title_p, openResourceDialogTitle_p, parent_p, container_p, filterExtension_p){

            protected void doFillIntoGrid(Composite parent__p, int numColumns_p) {
                super.doFillIntoGrid(parent__p, numColumns_p);
                this.getChangeControl(parent__p).setEnabled(!readOnly_p);
            }
        };
        fieldEditor.setEmptyStringAllowed(false);
        return fieldEditor;
    }

    public static DomainFieldEditor createDomainFieldEditor(Composite parent_p, String title_p, String openResourceDialogTitle_p, IContainer container_p, String filterExtension_p, final boolean readOnly_p) {
        DomainFieldEditor fieldEditor = new DomainFieldEditor(title_p, openResourceDialogTitle_p, parent_p, container_p, filterExtension_p){

            protected void doFillIntoGrid(Composite parent__p, int numColumns_p) {
                super.doFillIntoGrid(parent__p, numColumns_p);
                this.getChangeControl(parent__p).setEnabled(!readOnly_p);
            }
        };
        fieldEditor.setEmptyStringAllowed(false);
        ((Text)fieldEditor.getValueControl()).setEditable(false);
        return fieldEditor;
    }

    public static void layoutFieldEditor(Composite parent_p, FieldEditor fieldEditor_p, int numColumns_p) {
        ((GridLayout)parent_p.getLayout()).numColumns = numColumns_p;
        fieldEditor_p.fillIntoGrid(parent_p, numColumns_p);
    }
}

