/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.internal.field;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredJavaTypeSelectionExtension
extends TypeSelectionExtension {
    protected static final Logger __logger = Logger.getLogger((String)FilteredJavaTypeSelectionExtension.class.getPackage().getName());
    protected Class<?> _classTypeFilter;
    protected IJavaProject _javaProject;

    public FilteredJavaTypeSelectionExtension(IJavaProject javaProject_p, Class<?> classTypeFilter_p) {
        Assert.isNotNull((Object)javaProject_p);
        Assert.isNotNull(classTypeFilter_p);
        this._javaProject = javaProject_p;
        this._classTypeFilter = classTypeFilter_p;
    }

    public ITypeInfoFilterExtension getFilterExtension() {
        return new ITypeInfoFilterExtension(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean select(ITypeInfoRequestor typeInfoRequestor_p) {
                StringBuilder fqn = new StringBuilder(typeInfoRequestor_p.getPackageName()).append('.').append(typeInfoRequestor_p.getTypeName());
                try {
                    IType type = FilteredJavaTypeSelectionExtension.this._javaProject.findType(fqn.toString());
                    if (type == null) return false;
                    String[] stringArray = type.getSuperInterfaceNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        String i = stringArray[n2];
                        if (FilteredJavaTypeSelectionExtension.this._classTypeFilter.getName().equals(i)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    return true;
                }
            }
        };
    }

    public static boolean implementInterface(Class<?> clazz, String interfaceName) {
        if (clazz == null || interfaceName == null) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaces = classArray[n2];
            if (interfaceName.equals(interfaces.getName())) {
                return true;
            }
            ++n2;
        }
        return FilteredJavaTypeSelectionExtension.implementInterface(clazz.getSuperclass(), interfaceName);
    }
}

