/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import org.apache.log4j.Logger;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.DataBindingHelper;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.toolkit.fields.CRadioGroupFieldEditor;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternBlock;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PatternProductionPage
extends AbstractPatternPage {
    static final Logger __logger = Logger.getLogger((String)PatternProductionPage.class.getPackage().getName());
    protected static final String ID = "egf_pattern_production_page";
    protected static final String HELP_CONTEXT_ID = String.valueOf(PatternUiActivator.getDefault().getPluginID()) + '.' + "egf_pattern_production_page";
    private ProductionHandler _productionHandler;

    public PatternProductionPage(FormEditor editor_p) {
        super(editor_p, ID, Messages.PatternProductionPage_Title);
    }

    public void handleSelection(Object firstSelectedObject_p, IStructuredSelection selection_p) {
        this.getEditor().setActivePage(ID);
    }

    protected AbstractPatternBlock createPatternBlock() {
        return null;
    }

    protected void doCreateFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
        FormHelper.updateCompositeLayoutWithLayoutType((Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
        this.createProductionOptionsSection(toolkit_p, parent_p, patternData_p);
    }

    private void createProductionOptionsSection(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p) {
        Text destinationPathText;
        CRadioGroupFieldEditor bufferModificationRadioGroup;
        CRadioGroupFieldEditor compilationRadioGroup;
        this._productionHandler = new ProductionHandler(patternData_p);
        Couple optionsCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parent_p, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
        Section optionsSection = (Section)optionsCouple.getKey();
        optionsSection.setText(Messages.PatternOverviewPage_Section_ProductionOptions_Text);
        Composite parentOptionsComposite = (Composite)optionsCouple.getValue();
        Button overrideButton = toolkit_p.createButton(parentOptionsComposite, Messages.PatternOverviewPage_ProductionOptions_Override_Button_Text, 32);
        overrideButton.setEnabled(this.isEditable());
        overrideButton.addSelectionListener((SelectionListener)this._productionHandler);
        boolean optionsEnabled = this._productionHandler.isEnabled();
        overrideButton.setSelection(optionsEnabled);
        Group optionsComposite = FieldEditorHelper.createGroup((Composite)parentOptionsComposite, (String)Messages.PatternOverviewPage_Section_ProductionOptions_Text, (int)0, (int)1);
        toolkit_p.createLabel((Composite)optionsComposite, Messages.PatternOverviewPage_ProductionOptions_CompileTemplate_Description);
        String trueString = Boolean.TRUE.toString();
        String falseString = Boolean.FALSE.toString();
        String[][] compilationOptions = new String[][]{{Messages.PatternOverviewPage_ProductionOptions_CompileTemplate_Compile_Choice_Label, trueString}, {Messages.PatternOverviewPage_ProductionOptions_CompileTemplate_Skip_Choice_Label, falseString}};
        this._productionHandler._compilationSource = compilationRadioGroup = FieldEditorHelper.createRadioGroupFieldEditor((Composite)optionsComposite, (String)Messages.PatternOverviewPage_ProductionOptions_CompileTemplate_Title, (int)2, (String[][])compilationOptions, (!this.isEditable() ? 1 : 0) != 0);
        compilationRadioGroup.setPropertyChangeListener((IPropertyChangeListener)this._productionHandler);
        toolkit_p.createLabel((Composite)optionsComposite, Messages.PatternOverviewPage_ProductionOptions_ModifyBuffer_Description);
        String[][] bufferModificationOptions = new String[][]{{Messages.PatternOverviewPage_ProductionOptions_ModifyBuffer_Enabled_Choice_Label, trueString}, {Messages.PatternOverviewPage_ProductionOptions_ModifyBuffer_Disabled_Choice_Label, falseString}};
        this._productionHandler._bufferModificationSource = bufferModificationRadioGroup = FieldEditorHelper.createRadioGroupFieldEditor((Composite)optionsComposite, (String)Messages.PatternOverviewPage_ProductionOptions_ModifyBuffer_Title, (int)2, (String[][])bufferModificationOptions, (!this.isEditable() ? 1 : 0) != 0);
        bufferModificationRadioGroup.setPropertyChangeListener((IPropertyChangeListener)this._productionHandler);
        Couple destinationPathCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)optionsComposite, (int)64, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)2, (boolean)false);
        Section destinationPathSection = (Section)destinationPathCouple.getKey();
        destinationPathSection.setText(Messages.PatternOverviewPage_ProductionOptions_TemplatePath_Section_Text);
        destinationPathSection.setFont(bufferModificationRadioGroup.getRadioBoxControl((Composite)optionsComposite).getFont());
        destinationPathSection.setForeground(toolkit_p.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite destinationPathComposite = (Composite)destinationPathCouple.getValue();
        Label destinationPathDescriptionLabel = toolkit_p.createLabel(destinationPathComposite, Messages.PatternOverviewPage_ProductionOptions_TemplatePath_Description);
        GridData gilData = new GridData(768);
        gilData.horizontalSpan = 2;
        destinationPathDescriptionLabel.setLayoutData((Object)gilData);
        this._productionHandler._templateRelativePath = destinationPathText = (Text)FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)destinationPathComposite, (String)Messages.PatternOverviewPage_ProductionOptions_TemplatePath_Label, null, (boolean)this.isEditable()).getValue();
        AbstractPatternPage.TextValidator textValidator = new AbstractPatternPage.TextValidator(this, (Control)destinationPathText){

            protected String getErrorMessageFor(String errorKey_p, String value_p) {
                if ("RegExp" == errorKey_p) {
                    return Messages.PatternOverviewPage_ProductionOptions_TemplatePath_Validation_Error_Message;
                }
                return null;
            }
        };
        textValidator.setRegularExpression(Messages.PatternOverviewPage_ProductionOptions_TemplatePath_Validation_RegularExpression);
        DataBindingHelper.bindTextToProperty((Control)destinationPathText, (String)"destinationPath", (Object)this._productionHandler, (IValueChangeListener)textValidator);
        this._productionHandler.updateUiEnablement(optionsEnabled);
        this._productionHandler.refreshUiValues();
    }

    public void dataSaved() {
        if (this._productionHandler != null) {
            this._productionHandler.refreshUiValues();
        }
    }

    public String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private class ProductionHandler
    extends DefaultContentHandler
    implements IPropertyChangeListener,
    SelectionListener {
        protected static final String DATA_BINDING_TEMPLATE_DESTINATION_PATH = "destinationPath";
        private PatternHandler.ProductionOptionsHandler _optionsHandler;
        protected CRadioGroupFieldEditor _compilationSource;
        protected CRadioGroupFieldEditor _bufferModificationSource;
        protected Text _templateRelativePath;
        private boolean _ignoreNextTemplatePathValue;

        protected ProductionHandler(PatternHandler.PatternData patternData_p) {
            super(patternData_p, PatternProductionPage.this);
            this._optionsHandler = patternData_p.getProductionOptionsHandler();
            this._ignoreNextTemplatePathValue = false;
        }

        public String getDestinationPath() {
            return this._optionsHandler.getPatternTemplatePath();
        }

        public void setDestinationPath(String newTemplateDestinationPath_p) {
            if (!this._ignoreNextTemplatePathValue) {
                this._optionsHandler.setPatternTemplatePath(newTemplateDestinationPath_p);
                this.notifyModification();
            } else {
                this._ignoreNextTemplatePathValue = false;
            }
        }

        protected boolean shouldCompile() {
            return this._optionsHandler.shouldCompileTemplate();
        }

        protected boolean shouldModifyBuffer() {
            return this._optionsHandler.shouldModifyBuffer();
        }

        protected boolean isEnabled() {
            return this._optionsHandler.isEnabled();
        }

        protected void setEnabled(boolean enabled_p) {
            this._optionsHandler.setEnabled(enabled_p);
            this.updateUiEnablement(enabled_p);
            this.notifyModification();
        }

        protected void updateUiEnablement(boolean enabled_p) {
            this._compilationSource.setEnabled(enabled_p, null);
            this._bufferModificationSource.setEnabled(enabled_p, null);
            this._templateRelativePath.setEnabled(enabled_p);
        }

        protected void refreshUiValues() {
            this._compilationSource.setPropertyChangeListener(null);
            this._bufferModificationSource.setPropertyChangeListener(null);
            this._ignoreNextTemplatePathValue = true;
            String selectedValue = Boolean.toString(this._optionsHandler.shouldCompileTemplate());
            this._compilationSource.selectRadioButtonFor((Object)selectedValue);
            selectedValue = Boolean.toString(this._optionsHandler.shouldModifyBuffer());
            this._bufferModificationSource.selectRadioButtonFor((Object)selectedValue);
            this._templateRelativePath.setText(this._optionsHandler.getPatternTemplatePath());
            this._compilationSource.setPropertyChangeListener((IPropertyChangeListener)this);
            this._bufferModificationSource.setPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent event_p) {
            Object source = event_p.getSource();
            boolean notify = false;
            if (source.equals(this._compilationSource)) {
                this._optionsHandler.setCompileTemplateTo(Boolean.valueOf((String)event_p.getNewValue()).booleanValue());
                notify = true;
            } else if (source.equals(this._bufferModificationSource)) {
                this._optionsHandler.setModifyBufferTo(Boolean.valueOf((String)event_p.getNewValue()).booleanValue());
                notify = true;
            }
            if (notify) {
                this.notifyModification();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e_p) {
        }

        public void widgetSelected(SelectionEvent e_p) {
            Object source = e_p.getSource();
            if (source instanceof Button) {
                this.setEnabled(((Button)source).getSelection());
            }
        }
    }
}

