/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fc.generator.java.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.listener.DefaultResourceListener;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.progress.IProgressRunnable;
import org.eclipse.egf.common.progress.ProgressReporter;
import org.eclipse.egf.core.ui.actions.AbstractGenerateCodeOperation;
import org.eclipse.egf.fc.generator.java.helper.FileNameHelper;
import org.eclipse.egf.fc.generator.java.internal.Messages;
import org.eclipse.egf.fc.generator.java.internal.model.api.JavaApiCodeGenerator;
import org.eclipse.egf.fc.generator.java.model.AbstractGenModelGenerator;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.emf.PdeEmfActivator;
import org.eclipse.egf.pde.emf.plugin.command.EmfExtensionFactory;
import org.eclipse.egf.pde.emf.reader.descriptor.IEmfExtensionDescriptor;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;
import org.eclipse.egf.pde.plugin.manifest.command.ManifestChangeCommandFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateJavaCodeOperation
extends AbstractGenerateCodeOperation {
    private IPath _inputPath;
    private String _projectName;
    private String _basePackage;
    private AbstractGenModelGenerator _genModelGenerator;
    private String _rootExtendsInterface;
    private String _rootExtendsClass;
    private GenJDKLevel _jdkComplianceLevel;
    private String _modelDirectory;
    private GenResourceKind _resourceType;
    private String _implementationPackageSuffix;
    private String _interfacePackageSuffix;
    private String _metadataPackageSuffix;
    private String _utilityPackageSuffix;

    public GenerateJavaCodeOperation(IPath inputPath_p, String projectName_p, String basePackage_p, AbstractGenModelGenerator genModelGenerator_p) {
        this._inputPath = inputPath_p;
        this._projectName = projectName_p;
        this._basePackage = basePackage_p;
        this._genModelGenerator = genModelGenerator_p;
        this.initializeDefaultValues();
    }

    private void initializeDefaultValues() {
        this._rootExtendsInterface = EObject.class.getName();
        this._rootExtendsClass = EObjectImpl.class.getName();
        this._jdkComplianceLevel = this.getDefaultJDKComplianceLevel();
        this._modelDirectory = "src";
        this._resourceType = this.getDefaultResourceType();
        this._implementationPackageSuffix = "impl";
        this._interfacePackageSuffix = "";
        this._metadataPackageSuffix = "";
        this._utilityPackageSuffix = "util";
    }

    private GenJDKLevel getDefaultJDKComplianceLevel() {
        return GenJDKLevel.JDK14_LITERAL;
    }

    protected boolean doExecute(IProgressMonitor monitor_p) throws CoreException, InvocationTargetException, InterruptedException {
        Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)monitor_p);
        final boolean[] result = new boolean[1];
        ProjectHelper.ProjectExistenceStatus existenceStatus = ProjectHelper.ensurePluginProjectExists((String)this._projectName);
        if (ProjectHelper.ProjectExistenceStatus.CREATION_FAILED == existenceStatus) {
            return result[0];
        }
        final boolean[] created = new boolean[]{true};
        this._genModelGenerator.setPluginId(this._projectName);
        this._genModelGenerator.setInputPath(this._inputPath);
        this._genModelGenerator.setBasePackagePrefix(this._basePackage);
        this._genModelGenerator.setRootExtendsInterface(this._rootExtendsInterface);
        this._genModelGenerator.setRootExtendsClass(this._rootExtendsClass);
        this._genModelGenerator.setJdkComplianceLevel(this._jdkComplianceLevel);
        this._genModelGenerator.setModelDirectory(this._modelDirectory);
        this._genModelGenerator.setResourceType(this._resourceType);
        this._genModelGenerator.setPackagesSuffixes(this._implementationPackageSuffix, this._interfacePackageSuffix, this._metadataPackageSuffix, this._utilityPackageSuffix);
        GenModel genModel = this.loadExistingGenModel(this._inputPath, PdeEmfActivator.getDefault().getAllEmfExtensionDescriptors());
        boolean bl = created[0] = genModel == null;
        if (created[0]) {
            IEmfExtensionDescriptor[] extensions = this.cleanExtensions(this._inputPath, PdeEmfActivator.getDefault().getWorkspaceEmfExtensionDescriptors());
            this.registerExtensions(extensions);
            genModel = this._genModelGenerator.execute(monitor);
            this.unregisterExtensions(extensions);
        } else {
            this._genModelGenerator.setGenModelParameters(genModel);
        }
        result[0] = genModel != null;
        IFile pluginFile = FileHelper.getPlatformFile((String)(String.valueOf('/') + this._projectName + "/META-INF/MANIFEST.MF"));
        final GenModel genModelTemp = genModel;
        if (ProjectHelper.ProjectExistenceStatus.CREATED == existenceStatus) {
            DefaultResourceListener listener = new DefaultResourceListener(){

                protected void handleResourceChanged(IResourceChangeEvent event_p, IResource watchedResource_p) {
                    if (result[0]) {
                        IProgressRunnable updatePlugin = new IProgressRunnable(){

                            public String getReportingTitle() {
                                return String.valueOf(Messages.ModelApiGenerator_UpdateProjectAfterCreation) + GenerateJavaCodeOperation.this._projectName;
                            }

                            public boolean run(IProgressMonitor progressMonitor_p) {
                                if (!created[0]) {
                                    GenerateJavaCodeOperation.this.updateGeneratedPackageExtension(genModelTemp, true);
                                    GenerateJavaCodeOperation.this.updateRuntimePackages(genModelTemp, true);
                                }
                                EgfPdeActivator.getDefault().convertToFactoryComponent(GenerateJavaCodeOperation.this._projectName, true);
                                return true;
                            }
                        };
                        ProgressReporter.asyncExec((IProgressRunnable)updatePlugin);
                    }
                    this.dispose();
                }
            };
            listener.setResourceToWatch((IResource)pluginFile);
        }
        if (result[0]) {
            JavaApiCodeGenerator javaApiCodeGenerator = new JavaApiCodeGenerator(this.getGeneratorAdapterFactory());
            result[0] = javaApiCodeGenerator.generate(monitor, genModel);
            if (result[0] && created[0] && ProjectHelper.ProjectExistenceStatus.ALREADY_EXISTS == existenceStatus) {
                this.updateGeneratedPackageExtension(genModel, false);
                this.updateRuntimePackages(genModel, false);
            }
        }
        this._genModelGenerator.clear();
        return result[0];
    }

    public void setRootExtendsInterface(String rootExtendsInterface_p) {
        this._rootExtendsInterface = rootExtendsInterface_p;
    }

    public void setRootExtendsClass(String rootExtendsClass_p) {
        this._rootExtendsClass = rootExtendsClass_p;
    }

    public void setJdkComplianceLevel(GenJDKLevel jdkComplianceLevel_p) {
        this._jdkComplianceLevel = jdkComplianceLevel_p;
    }

    public void setResourceType(GenResourceKind resourceType_p) {
        this._resourceType = resourceType_p;
    }

    private GenResourceKind getDefaultResourceType() {
        return GenResourceKind.NONE_LITERAL;
    }

    public void setModelDirectory(String modelDirectory_p) {
        this._modelDirectory = modelDirectory_p;
    }

    protected void updateRuntimePackages(GenModel genModel_p, boolean remove_p) {
        List genPackages = genModel_p.getAllGenPackagesWithClassifiers();
        ArrayList<String> packagesToExport = new ArrayList<String>(0);
        for (GenPackage genPackage : genPackages) {
            String packageNameImpl = genPackage.getClassPackageName();
            if (packageNameImpl == null) continue;
            int indexOfPoint = packageNameImpl.lastIndexOf(46);
            String packageName = null;
            if (indexOfPoint > -1) {
                packageName = packageNameImpl.substring(0, packageNameImpl.lastIndexOf(46));
            }
            if (packageName != null) {
                packagesToExport.add(packageName);
                packagesToExport.add(String.valueOf(packageName) + ".util");
            }
            packagesToExport.add(packageNameImpl);
        }
        if (packagesToExport.size() > 0) {
            String[] packagesNames = packagesToExport.toArray(new String[packagesToExport.size()]);
            IPluginChangesCommandRunner runner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
            IPluginChangesCommand command = remove_p ? ManifestChangeCommandFactory.unsetExportedPackages((String[])packagesNames) : ManifestChangeCommandFactory.setExportedPackages((String[])packagesNames);
            runner.performChangesOnManifest(genModel_p.getModelPluginID(), Collections.singletonList(command));
        }
    }

    protected void updateGeneratedPackageExtension(GenModel genModel_p, boolean remove_p) {
        String genModelPath = genModel_p.getRelativeGenModelLocation();
        ArrayList<IPluginChangesCommand> commands = new ArrayList<IPluginChangesCommand>(1);
        List allGenPackagesWithClassifiers = genModel_p.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : allGenPackagesWithClassifiers) {
            String uri = genPackage.getNSURI();
            if (remove_p) {
                commands.add(EmfExtensionFactory.unsetEmfGeneratedPackageExtension((String)uri));
                continue;
            }
            String packageClassName = genPackage.getQualifiedPackageInterfaceName();
            commands.add(EmfExtensionFactory.setEmfGeneratedPackageExtension((String)uri, (String)packageClassName, (String)genModelPath));
        }
        if (!commands.isEmpty()) {
            IPluginChangesCommandRunner runner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
            runner.performChangesOnPlugin(genModel_p.getModelPluginID(), commands);
        }
    }

    protected IEmfExtensionDescriptor[] cleanExtensions(IPath modelPath_p, Collection<IEmfExtensionDescriptor> extensions_p) {
        String modelPath = FileNameHelper.getGenModelPath(modelPath_p);
        Iterator<IEmfExtensionDescriptor> emfExtensionDescriptors = extensions_p.iterator();
        while (emfExtensionDescriptors.hasNext()) {
            Couple generatedPackage = emfExtensionDescriptors.next().getGeneratedPackage();
            String nsUri = (String)generatedPackage.getKey();
            URI physicalUri = (URI)generatedPackage.getValue();
            if (physicalUri == null || physicalUri.toString().indexOf(modelPath) <= 0) continue;
            emfExtensionDescriptors.remove();
            EcorePlugin.getEPackageNsURIToGenModelLocationMap().remove(nsUri);
        }
        return extensions_p.toArray(new IEmfExtensionDescriptor[extensions_p.size()]);
    }

    protected void registerExtensions(IEmfExtensionDescriptor[] extensions_p) {
        Map map = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        IEmfExtensionDescriptor[] iEmfExtensionDescriptorArray = extensions_p;
        int n = extensions_p.length;
        int n2 = 0;
        while (n2 < n) {
            IEmfExtensionDescriptor emfExtensionDescriptor = iEmfExtensionDescriptorArray[n2];
            Couple generatedPackage = emfExtensionDescriptor.getGeneratedPackage();
            map.put((String)generatedPackage.getKey(), (URI)generatedPackage.getValue());
            ++n2;
        }
    }

    protected void unregisterExtensions(IEmfExtensionDescriptor[] extensions_p) {
        Map map = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        IEmfExtensionDescriptor[] iEmfExtensionDescriptorArray = extensions_p;
        int n = extensions_p.length;
        int n2 = 0;
        while (n2 < n) {
            IEmfExtensionDescriptor emfExtensionDescriptor = iEmfExtensionDescriptorArray[n2];
            Couple generatedPackage = emfExtensionDescriptor.getGeneratedPackage();
            map.remove(generatedPackage.getKey());
            ++n2;
        }
    }

    public void setImplementationPackageSuffix(String implementationPackageSuffix_p) {
        this._implementationPackageSuffix = implementationPackageSuffix_p;
    }

    public void setInterfacePackageSuffix(String interfacePackageSuffix_p) {
        this._interfacePackageSuffix = interfacePackageSuffix_p;
    }

    public void setMetadataPackageSuffix(String metadataPackageSuffix_p) {
        this._metadataPackageSuffix = metadataPackageSuffix_p;
    }

    public void setUtilityPackageSuffix(String utilityPackageSuffix_p) {
        this._utilityPackageSuffix = utilityPackageSuffix_p;
    }
}

