/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.edit.helper;

import org.apache.log4j.Logger;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.misc.PlatformLocationType;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.emf.common.util.URI;

public class FactoryComponentHelper {
    private static final Logger __logger = Logger.getLogger((String)FactoryComponentHelper.class.getPackage().getName());

    public static String getPluginId(String fcId_p, PlatformLocationType search_p) {
        String result = null;
        switch (search_p) {
            case TARGET_PLATFORM_ONLY: {
                result = FactoryComponentHelper.lookupInTargetPlatform(fcId_p);
                break;
            }
            case WORKSPACE_ONLY: {
                result = FactoryComponentHelper.lookupInWorkspace(fcId_p);
                break;
            }
            case TARGET_PLATFORM_THEN_WORKSPACE: {
                result = FactoryComponentHelper.lookupInTargetPlatform(fcId_p);
                if (result != null) break;
                result = FactoryComponentHelper.lookupInWorkspace(fcId_p);
                break;
            }
            case WORKSPACE_THEN_TARGET_PLATFORM: {
                result = FactoryComponentHelper.lookupInWorkspace(fcId_p);
                if (result != null) break;
                result = FactoryComponentHelper.lookupInTargetPlatform(fcId_p);
                break;
            }
            default: {
                StringBuilder loggerMessage = new StringBuilder("FactoryComponentHelper.getPluginId(..) _ ");
                loggerMessage.append("Unknown search flag:").append(search_p);
                __logger.error((Object)loggerMessage.toString());
            }
        }
        return result;
    }

    public static URI getDomainURI(String fcId_p) {
        String pluginId;
        URI domainUri = null;
        FactoryComponent fc = CoreActivator.getDefault().getFactoryComponent(fcId_p);
        if (fc == null) {
            return domainUri;
        }
        Domain domain = fc.getDomain();
        if (ModelHelper.isDomainDefined((Domain)domain) && (pluginId = FactoryComponentHelper.getPluginId(fcId_p, PlatformLocationType.WORKSPACE_THEN_TARGET_PLATFORM)) != null) {
            StringBuilder domainPath = new StringBuilder().append('/').append(pluginId).append('/').append(domain.getPath());
            domainUri = FileHelper.getFileFullUri((String)domainPath.toString());
        }
        return domainUri;
    }

    private static String lookupInWorkspace(String fcId_p) {
        return EgfPdeActivator.getDefault().getPluginIdForFactoryComponent(fcId_p);
    }

    private static String lookupInTargetPlatform(String fcId_p) {
        return CoreActivator.getDefault().getPluginIdForFactoryComponent(fcId_p);
    }
}

