/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.activator.AbstractActivator;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.common.progress.IProgressRunnable;
import org.eclipse.egf.common.progress.ProgressReporter;
import org.eclipse.egf.core.Log4JConfigurator;
import org.eclipse.egf.core.data.FactoryComponentRegistry;
import org.eclipse.egf.core.internal.helper.FactoryComponentSortingPriorityHelper;
import org.eclipse.egf.core.internal.production.Messages;
import org.eclipse.egf.core.internal.production.ProductionManager;
import org.eclipse.egf.core.internal.reader.DefaultFactoryComponentReader;
import org.eclipse.egf.core.reader.descriptor.FactoryComponentDescriptor;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.ModelActivator;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreActivator
extends AbstractActivator {
    private static final Logger __logger = Logger.getLogger((String)CoreActivator.class.getPackage().getName());
    private static CoreActivator __plugin;
    private ProductionManager _productionManager;
    private FactoryComponentRegistry _fcRegistry;

    public static CoreActivator getDefault() {
        return __plugin;
    }

    public void start(BundleContext context_p) throws Exception {
        super.start(context_p);
        __plugin = this;
        Log4JConfigurator.configure(this.getBundle());
    }

    public void stop(BundleContext context_p) throws Exception {
        __plugin = null;
        super.stop(context_p);
    }

    public boolean generateFactoryComponentSynchronously(FactoryComponent factoryComponent_p) {
        boolean result = false;
        if (factoryComponent_p == null) {
            return result;
        }
        FactoryComponentRegistry fcRegistry = this.getFactoryComponentRegistry();
        String fcId = factoryComponent_p.getId();
        FactoryComponent alreadyKnownFc = fcRegistry.getFactoryComponent(fcId);
        boolean removeFromRegistry = false;
        if (alreadyKnownFc != null && alreadyKnownFc != factoryComponent_p) {
            StringBuilder loggerMessage = new StringBuilder("CoreActivator.generateFactoryComponentSynchronously(..) _ ");
            loggerMessage.append("Prevented corruption status to occur !");
            loggerMessage.append("Trying to execute factory component ").append(factoryComponent_p.getName());
            loggerMessage.append(" in replacement of ").append(alreadyKnownFc.getName());
            loggerMessage.append(" .Both are having the same ID, and yet there are not equal !");
            __logger.warn((Object)loggerMessage.toString());
            return result;
        }
        if (alreadyKnownFc == null) {
            removeFromRegistry = true;
            fcRegistry.addFactoryComponent(fcId, factoryComponent_p);
        }
        result = this.generateFactoryComponent(fcId, null, false);
        if (removeFromRegistry) {
            fcRegistry.removeFactoryComponent(fcId);
        }
        return result;
    }

    public boolean generateFactoryComponent(final String factoryComponentId_p, IProgressMonitor progressMonitor_p, boolean forkJob_p) {
        boolean result = true;
        if (this._productionManager == null) {
            this._productionManager = new ProductionManager();
        }
        final ProductionManager productionManager = this._productionManager;
        IProgressRunnable generateFc = new IProgressRunnable(){

            public String getReportingTitle() {
                return String.valueOf(Messages.ProductionManager_ProgressReporting_Title) + factoryComponentId_p;
            }

            public boolean run(IProgressMonitor runnableProgressMonitor_p) {
                return productionManager.generate(factoryComponentId_p, runnableProgressMonitor_p);
            }
        };
        if (forkJob_p) {
            ProgressReporter.asyncExec((IProgressRunnable)generateFc);
        } else {
            result = ProgressReporter.syncExec((IProgressRunnable)generateFc, (IProgressMonitor)progressMonitor_p);
        }
        return result;
    }

    public Collection<FactoryComponent> getFactoryComponentsInPlatform() {
        ArrayList<FactoryComponent> resultingFcList = new ArrayList<FactoryComponent>(0);
        IConfigurationElement[] fcConfigurationElements = ExtensionPointHelper.getConfigurationElements((String)this.getPluginID(), (String)"factoryComponent");
        DefaultFactoryComponentReader factoryComponentReader = new DefaultFactoryComponentReader();
        int i = 0;
        while (i < fcConfigurationElements.length) {
            FactoryComponentDescriptor fcDescriptor = factoryComponentReader.readFactoryComponent(fcConfigurationElements[i]);
            resultingFcList.add(this.getFactoryComponent(fcDescriptor));
            ++i;
        }
        return resultingFcList;
    }

    public IFactoryComponentDescriptor getFactoryComponentDescriptorFromPlatform(IConfigurationElement configurationElement_p) {
        DefaultFactoryComponentReader factoryComponentReader = new DefaultFactoryComponentReader();
        return factoryComponentReader.readFactoryComponent(configurationElement_p);
    }

    public String getPluginIdForFactoryComponent(String factoryComponentId_p) {
        String result = null;
        IConfigurationElement fcConfigurationElement = ExtensionPointHelper.getConfigurationElement((String)this.getPluginID(), (String)"factoryComponent", (String)factoryComponentId_p);
        if (fcConfigurationElement != null) {
            result = fcConfigurationElement.getContributor().getName();
        }
        return result;
    }

    public Bundle getBundleForFactoryComponent(NamedModelElementWithId modelElement_p) {
        String pluginID;
        Bundle bundle = null;
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)modelElement_p);
        if (fcContainer != null && (pluginID = this.getPluginIdForFactoryComponent(fcContainer.getId())) != null) {
            bundle = Platform.getBundle((String)pluginID);
        }
        return bundle;
    }

    public FactoryComponent getFactoryComponent(String factoryComponentId_p) {
        return ModelActivator.getDefault().getFactoryComponentLoadingHelper().getFactoryComponent(factoryComponentId_p);
    }

    public FactoryComponent getFactoryComponent(IFactoryComponentDescriptor fcDescriptor_p) {
        return ModelActivator.getDefault().getFactoryComponentLoadingHelper().getFactoryComponent(fcDescriptor_p);
    }

    public FactoryComponentRegistry getFactoryComponentRegistry() {
        if (this._fcRegistry == null) {
            this._fcRegistry = FactoryComponentRegistry.getInstance();
        }
        return this._fcRegistry;
    }

    public int getSortingPriority(NamedModelElementWithId modelElement_p) {
        return FactoryComponentSortingPriorityHelper.getInstance().getSortingPriority(modelElement_p);
    }
}

