/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.PatternFactory;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.GeneratedContentHelper;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pattern.relations.ParameterRelation;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatternGenerator {
    private static final Logger __logger = Logger.getLogger((String)AbstractPatternGenerator.class.getPackage().getName());
    protected static final String ECORE_ECORE_FILE_ABSOLUTE_PATH = "/org.eclipse.emf.ecore/model/Ecore.ecore";
    protected static final String PATTERN_ECORE_FILE_RELATIVE_PATH = "/org.eclipse.egf.model/model/pattern.ecore";
    protected static final String PATTERN_PARENT_CLASS_NAME = "Pattern";
    protected static final String TEMPLATES_FOLDER_NAME = "/templates/";
    protected static final String GENERATED_TEMPLATE_FOLDER_PATH = "generated";

    protected static EClass getDependencyFromName(String name_p, String ecoreURI_p, ResourceSet resourceSet_p) {
        EClass result = null;
        if (name_p == null || ecoreURI_p == null || resourceSet_p == null) {
            return result;
        }
        try {
            URI patternURI = FileHelper.getFileFullUri((String)ecoreURI_p);
            Resource parentResource = resourceSet_p.getResource(patternURI, true);
            TreeIterator content = parentResource.getAllContents();
            while (content.hasNext() && result == null) {
                EClass class_;
                EObject object = (EObject)content.next();
                if (!(object instanceof EClass) || !name_p.equals((class_ = (EClass)object).getName())) continue;
                result = class_;
            }
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("AbstractPatternGenerator.getDependencyFromName(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    protected List<ParameterRelation> getPatternParameters(ResourceSet resourceSet_p) {
        return null;
    }

    public static void setPatternParent(Pattern pattern_p, String parentClassName_p, String parentEcoreURI_p, ResourceSet resourceSet_p) {
        ResourceSet resourceSet = resourceSet_p;
        if (pattern_p == null) {
            return;
        }
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        String parentClassName = parentClassName_p;
        String parentEcoreURI = parentEcoreURI_p;
        if (parentClassName == null || parentEcoreURI == null) {
            parentClassName = PATTERN_PARENT_CLASS_NAME;
            parentEcoreURI = PATTERN_ECORE_FILE_RELATIVE_PATH;
        }
        EClass parent = AbstractPatternGenerator.getDependencyFromName(parentClassName, parentEcoreURI, resourceSet);
        pattern_p.getESuperTypes().clear();
        if (parent != null) {
            pattern_p.getESuperTypes().add((Object)parent);
        }
    }

    public boolean generateEcoreFile() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Pattern newPattern = PatternFactory.eINSTANCE.createPattern();
        newPattern.setId(this.getPatternFullId());
        AbstractPatternGenerator.setPatternParent(newPattern, this.getParentClassName(), this.getParentEcoreURI(), (ResourceSet)resourceSet);
        List<ParameterRelation> parameters = this.getPatternParameters((ResourceSet)resourceSet);
        if (parameters != null) {
            newPattern.getParameters().addAll(parameters);
        }
        AnnotationHandler annotationHandler = new AnnotationHandler();
        EOperation generateOperation = AbstractPatternGenerator.addOperation(newPattern, "generateBody");
        EParameter classLoaderParameter = EcoreFactory.eINSTANCE.createEParameter();
        classLoaderParameter.setName("classLoader_p");
        classLoaderParameter.setEType((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        generateOperation.getEParameters().add((Object)classLoaderParameter);
        AbstractPatternGenerator.addOperation(newPattern, "generatePreMatching");
        AbstractPatternGenerator.addOperation(newPattern, "generatePostMatching");
        EOperation generateHeader = AbstractPatternGenerator.addOperation(newPattern, "generateHeader");
        annotationHandler.addUidAnnotation(generateHeader);
        EOperation generateFooter = AbstractPatternGenerator.addOperation(newPattern, "generateFooter");
        annotationHandler.addUidAnnotation(generateFooter);
        this.fillPattern(newPattern, annotationHandler, generateOperation);
        String patternContainingPluginId = this.getPatternContainingPluginId();
        FactoryComponent containingFc = EgfPdeActivator.getDefault().getFactoryComponentForPluginId(patternContainingPluginId);
        AbstractPatternGenerator.computeOperationsAnnotations(newPattern, containingFc == null ? patternContainingPluginId : containingFc.getId(), annotationHandler);
        return AbstractPatternGenerator.writePatternModelToFile(newPattern, AbstractPatternGenerator.getPatternModelRelativePath(patternContainingPluginId, (String)PatternHelper.deresolveId((String)newPattern.getId()).getValue()));
    }

    public static void computeOperationsAnnotations(Pattern pattern_p, String fcId_p, AnnotationHandler annotationHandler_p) {
        if (pattern_p == null) {
            return;
        }
        AnnotationHandler handler = annotationHandler_p;
        if (handler == null) {
            handler = new AnnotationHandler();
        }
        String patternShortId = (String)PatternHelper.deresolveId((String)pattern_p.getId()).getValue();
        EList operations = pattern_p.getEOperations();
        for (EOperation operation : operations) {
            String templateRelativePath = TemplateHelper.getTemplateRelativePath(patternShortId, fcId_p, operation.getName(), handler.getUid(operation));
            if (templateRelativePath == null || handler.hasPatternCode(operation)) continue;
            handler.addReadFilePatternCode(operation, templateRelativePath);
        }
        handler.translateAnnotations((List<EOperation>)operations);
    }

    public static void computeProductionAnnotation(Pattern pattern_p, PatternHandler.ProductionOptionsHandler handler_p, AnnotationHandler annotationHandler_p) {
        boolean successful;
        AnnotationHandler annotationHandler = annotationHandler_p;
        if (annotationHandler == null) {
            annotationHandler = new AnnotationHandler();
        }
        if (!(successful = annotationHandler.addProductionAnnotation(pattern_p, handler_p))) {
            __logger.warn((Object)("AbstractPatternGenerator.computeProductionAnnotation(..) _ " + "Could not set production annotation for pattern " + (pattern_p != null ? pattern_p.getName() : null)));
        }
    }

    public static String getPatternModelRelativePath(String containerId_p, String patternId_p) {
        if (containerId_p == null || patternId_p == null) {
            return null;
        }
        return containerId_p + "/model/pattern/" + StringHelper.replaceNonWordCharactersWithDot((String)patternId_p) + '.' + "pm";
    }

    static boolean writePatternModelToFile(Pattern pattern_p, String fileRelativePath_p) {
        boolean result = false;
        boolean writable = FileHelper.makeFileWritable((String)fileRelativePath_p);
        if (!writable) {
            return result;
        }
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName(GeneratedContentHelper.getPatternPackageName(pattern_p));
        container.setNsURI(GeneratedContentHelper.getPatternPackageNsURI(pattern_p));
        container.setNsPrefix(GeneratedContentHelper.getPatternPackageNsPrefix(pattern_p));
        container.getEClassifiers().add((Object)pattern_p);
        try {
            URI fileFullUri = FileHelper.getFileFullUri((String)fileRelativePath_p);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource patternResource = resourceSet.createResource(fileFullUri);
            patternResource.getContents().add((Object)container);
            patternResource.save(null);
            result = true;
        }
        catch (Exception exception_p) {
            result = false;
            StringBuilder loggerMessage = new StringBuilder("AbstractPatternGenerator.writePatternModelToFile(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    public static EOperation addOperation(Pattern pattern_p, String operationName_p) {
        EOperation newOperation = EcoreFactory.eINSTANCE.createEOperation();
        newOperation.setName(operationName_p);
        newOperation.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        pattern_p.getEOperations().add((Object)newOperation);
        return newOperation;
    }

    public static void removeOperation(Pattern pattern_p, EOperation operation_p) {
        if (pattern_p != null && operation_p != null) {
            pattern_p.getEOperations().remove((Object)operation_p);
        }
    }

    protected String getPatternShortId(Pattern pattern_p) {
        String result = null;
        if (pattern_p == null) {
            return result;
        }
        result = (String)PatternHelper.deresolveId((String)pattern_p.getId()).getValue();
        return result;
    }

    protected String getTemplateRelativePath(String patternShortId_p, String operationName_p, String operationId_p) {
        return TemplateHelper.getTemplateRelativePath(patternShortId_p, this.getPatternContainingPluginId(), operationName_p, operationId_p);
    }

    protected abstract void fillPattern(Pattern var1, AnnotationHandler var2, EOperation var3);

    protected String getParentClassName() {
        return null;
    }

    protected String getParentEcoreURI() {
        return null;
    }

    protected abstract String getPatternContainingPluginId();

    protected abstract String getPatternFullId();
}

