/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.internal.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.MathHelper;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.pattern.PatternActivator;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.internal.PatternRegistry;
import org.eclipse.egf.pattern.internal.PatternTemplateRegistry;
import org.eclipse.egf.pattern.production.GeneratedContentHelper;
import org.eclipse.egf.pattern.production.PatternTemplateProducer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternTemplateBuilder
extends IncrementalProjectBuilder {
    private static boolean DEBUG = PatternActivator.getDefault().isDebugging();
    private static IProject[] EMPTY_LIST = new IProject[0];
    private BinaryGeneratedPatternFolderVisitor _patternVisitor = new BinaryGeneratedPatternFolderVisitor();
    private IPath _binaryOutputPatternPath;
    private IJavaProject _javaProject;
    private Map<String, IDescriptor> _patterns;
    private Map<String, IDescriptor> _patternTemplates;

    protected IProject[] build(int kind_p, Map args_p, IProgressMonitor monitor_p) throws CoreException {
        if (!this.initialize(monitor_p)) {
            return EMPTY_LIST;
        }
        try {
            IResourceDelta delta = this.getDelta(this._javaProject.getProject());
            if (kind_p != 6 || delta != null) {
                if (delta.getKind() != 0) {
                    this._patternVisitor.reset();
                    delta.accept((IResourceDeltaVisitor)this._patternVisitor);
                    this.clean(this._patternVisitor.getClean());
                    this.generate(this._patternVisitor.getGenerate(), monitor_p);
                }
            } else {
                this.generate(this.getPatterns().values(), monitor_p);
            }
        }
        finally {
            this.cleanup();
        }
        return EMPTY_LIST;
    }

    protected void generate(Collection<IDescriptor> descriptors_p, IProgressMonitor monitor_p) {
        block12: {
            long start;
            if (descriptors_p == null) {
                return;
            }
            int rank = 1;
            long stepStart = start = System.currentTimeMillis();
            for (IDescriptor descriptor : descriptors_p) {
                String definition = (String)descriptor.getValue("model");
                if (definition == null || definition.trim().length() == 0) continue;
                PatternHandler patternHandler = new PatternHandler(true);
                try {
                    try {
                        PatternHandler.PatternData patternData = patternHandler.load(definition);
                        if (patternData != null) {
                            PatternTemplateProducer.generateTemplate(patternData);
                            if (DEBUG) {
                                long stepStop = System.currentTimeMillis();
                                EGFConsolePlugin.getConsole().logInfo(NLS.bind((String)"Generate Pattern Template ''{0}'', step {1}/{2}", (Object[])new Object[]{definition, rank++, descriptors_p.size()}));
                                EGFConsolePlugin.getConsole().logWarning(NLS.bind((String)"Total elapsed {0}, Step elapsed {1}", (Object)MathHelper.formatAsDuration((long)(stepStop - start)), (Object)MathHelper.formatAsDuration((long)(stepStop - stepStart))), 1);
                                stepStart = System.currentTimeMillis();
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (DEBUG) {
                            EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)"Unable to load Pattern Model ''{0}''", (Object)definition), t);
                        }
                        PatternActivator.getDefault().log(t);
                        if (!monitor_p.isCanceled()) continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (monitor_p.isCanceled()) break;
                    throw throwable;
                }
                if (monitor_p.isCanceled()) break;
            }
            try {
                this._javaProject.getProject().refreshLocal(2, monitor_p);
            }
            catch (CoreException ce) {
                PatternActivator.getDefault().log(ce);
                if (!DEBUG) break block12;
                EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)"Unable to refresh project ''{0}''", (Object)this._javaProject.getProject().getName()), (Throwable)ce);
            }
        }
    }

    protected void clean(Collection<IDescriptor> descriptors_p) {
        if (descriptors_p == null) {
            return;
        }
        for (IDescriptor descriptor : descriptors_p) {
            String id = (String)descriptor.getValue("id");
            if (id == null || id.trim().length() == 0) continue;
            if (DEBUG) {
                EGFConsolePlugin.getConsole().logInfo(NLS.bind((String)"Clean Pattern Template ''{0}''", (Object)id));
            }
            PatternTemplateProducer.cleanGeneratedStructures(this._javaProject, descriptor);
        }
    }

    private void cleanup() {
        this._patterns = null;
        this._patternTemplates = null;
    }

    protected void clean(IProgressMonitor monitor_p) throws CoreException {
        if (!this.initialize(monitor_p)) {
            return;
        }
        try {
            this.clean(this.getPatternTemplates().values());
        }
        finally {
            this.cleanup();
        }
    }

    private boolean initialize(IProgressMonitor monitor_p) throws CoreException {
        if (PatternActivator.getDefault().getBundle().getState() != 32 || monitor_p.isCanceled()) {
            return false;
        }
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return false;
        }
        this._javaProject = JavaCore.create((IProject)project);
        this._binaryOutputPatternPath = GeneratedContentHelper.getBinaryOutputPatternGeneratedFolder(this._javaProject);
        return this._binaryOutputPatternPath != null;
    }

    protected Map<String, IDescriptor> getPatterns() {
        if (this._patterns == null) {
            this._patterns = PatternRegistry.getPatterns(this._javaProject.getProject());
        }
        return this._patterns;
    }

    protected Map<String, IDescriptor> getPatternTemplates() {
        if (this._patternTemplates == null) {
            this._patternTemplates = PatternTemplateRegistry.getPatternTemplates(this._javaProject.getProject());
        }
        return this._patternTemplates;
    }

    protected IDescriptor getPattern(IFolder folder_p) {
        if (folder_p == null) {
            return null;
        }
        String shortID = GeneratedContentHelper.getPatternIdentifier(folder_p);
        if (shortID == null) {
            return null;
        }
        return this.getPatterns().get(shortID);
    }

    protected IDescriptor getPatternTemplate(IFolder folder_p) {
        if (folder_p == null) {
            return null;
        }
        String shortID = GeneratedContentHelper.getPatternIdentifier(folder_p);
        if (shortID == null) {
            return null;
        }
        return this.getPatternTemplates().get(shortID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BinaryGeneratedPatternFolderVisitor
    implements IResourceDeltaVisitor {
        private Collection<IDescriptor> _generate = new ArrayList<IDescriptor>();
        private Collection<IDescriptor> _clean = new ArrayList<IDescriptor>();

        BinaryGeneratedPatternFolderVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null) {
                int kind = delta.getKind();
                IResource resource = delta.getResource();
                if (resource.getType() == 2) {
                    if (PatternTemplateBuilder.this._binaryOutputPatternPath.toString().startsWith(resource.getFullPath().toString())) {
                        return true;
                    }
                    if (PatternTemplateBuilder.this._binaryOutputPatternPath.equals((Object)resource.getFullPath())) {
                        if (kind == 2) {
                            this._clean.addAll(PatternTemplateBuilder.this.getPatternTemplates().values());
                            return false;
                        }
                        return true;
                    }
                    if (resource.getFullPath().toString().startsWith(PatternTemplateBuilder.this._binaryOutputPatternPath.toString())) {
                        if (kind == 2) {
                            IDescriptor patternTemplateDescriptor = PatternTemplateBuilder.this.getPatternTemplate((IFolder)resource);
                            if (patternTemplateDescriptor == null) {
                                return false;
                            }
                            this._clean.add(patternTemplateDescriptor);
                        }
                        if (kind == 1 || kind == 4) {
                            IDescriptor patternDescriptor = PatternTemplateBuilder.this.getPattern((IFolder)resource);
                            if (patternDescriptor == null) {
                                return false;
                            }
                            this._generate.add(patternDescriptor);
                        }
                        return false;
                    }
                } else {
                    if (resource.getType() == 4) {
                        return true;
                    }
                    if (resource.getType() == 1) {
                        String fileExtension = resource.getFileExtension();
                        if (fileExtension == null || "".equals(fileExtension) || !"pt".equals(fileExtension) || !(resource.getParent() instanceof IFolder)) {
                            return false;
                        }
                        IDescriptor patternDescriptor = PatternTemplateBuilder.this.getPattern((IFolder)resource.getParent());
                        if (patternDescriptor == null) {
                            return false;
                        }
                        this._generate.add(patternDescriptor);
                    }
                }
            }
            return true;
        }

        public void reset() {
            this._generate.clear();
            this._clean.clear();
        }

        public Collection<IDescriptor> getGenerate() {
            return this._generate;
        }

        public Collection<IDescriptor> getClean() {
            return this._clean;
        }
    }
}

