/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.production;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.PatternActivator;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.GeneratedContentHelper;
import org.eclipse.egf.pattern.production.GeneratedContentProducer;
import org.eclipse.egf.pattern.production.Messages;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.pattern.plugin.command.PatternTemplateExtensionFactory;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class PatternTemplateProducer {
    private static boolean DEBUG = PatternActivator.getDefault().isDebugging();
    protected static final String PATTERN_FACTORY_CREATE_METHOD_PREFIX = "create";
    protected static final String PATTERN_FACTORY_NAME_SUFFIX = "Factory";
    protected static final String PATTERN_FACTORY_ATTRIBUTE_NAME = "eINSTANCE";

    public static boolean generateTemplate(PatternHandler.PatternData patternData_p) {
        String patternTemplatePath;
        block4: {
            try {
                patternTemplatePath = PatternTemplateProducer.doProducePattern(patternData_p);
                if (patternTemplatePath != null) break block4;
                return false;
            }
            catch (Exception e) {
                if (DEBUG) {
                    EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)Messages.PatternTemplateProducer_PatternProductionErrorMessage, (Object)patternData_p.getPatternLogicalName()), (Throwable)e);
                }
                PatternActivator.getDefault().log(e);
                return false;
            }
        }
        return !patternData_p.getProductionOptionsHandler().shouldCompileTemplate() || PatternTemplateProducer.compileResultingTemplate(patternTemplatePath, patternData_p);
    }

    public static String doProducePattern(PatternHandler.PatternData patternData_p) throws Exception {
        ClassLoader[] classLoader = new ClassLoader[1];
        Pattern pattern = PatternTemplateProducer.instantiatePattern(patternData_p, classLoader);
        if (pattern == null) {
            return null;
        }
        String templateContent = pattern.produce((Object)classLoader[0]);
        String patternTemplatePath = TemplateHelper.getPatternTemplatePath(patternData_p);
        if (FileHelper.writeFile((String)patternTemplatePath, (boolean)true, (String)templateContent)) {
            return patternTemplatePath;
        }
        return null;
    }

    public static Pattern instantiatePattern(PatternHandler.PatternData patternData_p, ClassLoader[] classLoader_p) throws Exception {
        if (patternData_p == null) {
            return null;
        }
        IJavaProject javaProject = patternData_p.getJavaProject();
        ClassLoader classLoader = classLoader_p[0];
        String pathString = "org.eclipse.egf.pattern" + '.' + GeneratedContentHelper.getPatternPackageName(patternData_p.getPattern()) + '.' + GeneratedContentHelper.getPatternClassName(patternData_p.getPattern()) + PATTERN_FACTORY_NAME_SUFFIX;
        IFile file = JavaHelper.getJavaSourceFile((IJavaProject)javaProject, (IPath)new Path(FileHelper.convertPackageNameToFolderPath((String)pathString)).addFileExtension("java"));
        if (file == null) {
            return null;
        }
        if (javaProject != null) {
            classLoader = ProjectHelper.getClassLoaderFor((IJavaProject)javaProject, (ClassLoader)((Object)((Object)PatternActivator.getDefault())).getClass().getClassLoader());
            if (classLoader == null) {
                classLoader = classLoader_p[0];
            } else {
                classLoader_p[0] = classLoader;
            }
        }
        if (classLoader == null) {
            return null;
        }
        Class<?> factoryInterface = null;
        try {
            factoryInterface = classLoader.loadClass(pathString);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Field factoryEInstance = factoryInterface.getDeclaredField(PATTERN_FACTORY_ATTRIBUTE_NAME);
        Object factoryObject = factoryEInstance.get(factoryInterface);
        Method createMethod = factoryInterface.getDeclaredMethod(PATTERN_FACTORY_CREATE_METHOD_PREFIX + patternData_p.getPatternName(), null);
        return (Pattern)createMethod.invoke(factoryObject, null);
    }

    public static boolean compileResultingTemplate(String patternTemplatePath_p, PatternHandler.PatternData patternData_p) throws Exception {
        return new GeneratedContentProducer().getProductionContributor().compileTemplate(patternTemplatePath_p, patternData_p);
    }

    protected static String getPatternTemplateAsString(PatternHandler.PatternData patternData_p, ClassLoader classLoader_p) {
        String result = "";
        ClassLoader[] classLoader = new ClassLoader[]{classLoader_p};
        try {
            Pattern pattern = PatternTemplateProducer.instantiatePattern(patternData_p, classLoader);
            if (pattern != null) {
                result = pattern.generate((Object)classLoader[0]);
            }
        }
        catch (Exception e) {
            String msg = new String("PatternTemplateProducer.getPatternTemplateAsString(..) _ ");
            if (DEBUG) {
                EGFConsolePlugin.getConsole().logThrowable(msg, (Throwable)e);
            }
            PatternActivator.getDefault().log(e);
        }
        return result;
    }

    public static void cleanGeneratedStructures(IJavaProject javaProject_p, IDescriptor descriptor_p) {
        if (javaProject_p == null || descriptor_p == null) {
            return;
        }
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject_p.getProject());
        if (model == null) {
            return;
        }
        String patternShortId = (String)descriptor_p.getValue("id");
        String patternTemplatePath = (String)descriptor_p.getValue("path");
        String patternTemplateClass = (String)descriptor_p.getValue("class");
        if (patternTemplatePath != null && patternTemplatePath.trim().length() > 0) {
            FileHelper.deleteResource((IFolder)TemplateHelper.getTemplateRootIFolder(javaProject_p), (IResource)FileHelper.getPlatformResource((IPath)new Path(patternTemplatePath)), (boolean)true);
        }
        if (patternTemplateClass != null && patternTemplateClass.trim().length() > 0) {
            JavaHelper.deleteJavaClass((IJavaProject)javaProject_p, (IPath)new Path(FileHelper.convertPackageNameToFolderPath((String)patternTemplateClass)).addFileExtension("java"), (boolean)true);
        }
        if (patternShortId != null && patternShortId.trim().length() > 0) {
            IPluginChangesCommandRunner pluginChangesCommandRunner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
            pluginChangesCommandRunner.performChangesOnPlugin(model.getBundleDescription().getSymbolicName(), Collections.singletonList(PatternTemplateExtensionFactory.unsetPatternTemplateExtension((String)patternShortId)));
        }
    }
}

