/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.reader;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.core.reader.descriptor.AbstractDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContextDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractElementReferenceDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentInvocationDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentReader;
import org.eclipse.egf.model.data.reader.descriptor.IProductionPlanDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.ITaskFactoryDescriptor;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.internal.reader.CreateContextDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateContractDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateContractElementReferenceOperation;
import org.eclipse.egf.pde.internal.reader.CreateFactoryComponentDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateFactoryComponentInvocationDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateMappingDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateProductionPlanDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateTaskFactoryDescriptorOperation;
import org.eclipse.egf.pde.reader.CreateDescriptorOperation;
import org.eclipse.egf.pde.reader.PdeAbstractReader;

public class WorkspaceFactoryComponentReader
extends PdeAbstractReader
implements IFactoryComponentReader {
    private static WorkspaceFactoryComponentReader __default;

    public static WorkspaceFactoryComponentReader getDefault() {
        if (__default == null) {
            __default = new WorkspaceFactoryComponentReader();
        }
        return __default;
    }

    public IFactoryComponentDescriptor readFactoryComponent(IProject project_p) {
        IFactoryComponentDescriptor result = null;
        if (project_p == null) {
            return result;
        }
        IFile pluginFile = EgfPdeActivator.getDefault().getFile(project_p);
        if (pluginFile != null) {
            result = (IFactoryComponentDescriptor)this.readDescriptor(new CreateFactoryComponentDescriptorOperation(pluginFile));
        }
        return result;
    }

    public IFactoryComponentDescriptor readFactoryComponent(String factoryComponentId_p) {
        return this.readFactoryComponent(EgfPdeActivator.getDefault().getProjectForFactoryComponent(factoryComponentId_p));
    }

    public IProductionPlanDescriptor readProductionPlan(String productionPlanId_p, String factoryComponentId_p) {
        IProductionPlanDescriptor result = (IProductionPlanDescriptor)this.readDescriptor(new CreateProductionPlanDescriptorOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p), productionPlanId_p));
        return result;
    }

    public IFactoryComponentInvocationDescriptor readFactoryComponentInvocation(String factoryComponentInvocation_p, String factoryComponentId_p) {
        IFactoryComponentInvocationDescriptor result = (IFactoryComponentInvocationDescriptor)this.readDescriptor(new CreateFactoryComponentInvocationDescriptorOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p), factoryComponentInvocation_p));
        return result;
    }

    public IContractDescriptor readContract(String contractId_p, String factoryComponentId_p) {
        IContractDescriptor result = (IContractDescriptor)this.readDescriptor(new CreateContractDescriptorOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p), contractId_p));
        return result;
    }

    public IContextDescriptor readContext(String contextId_p, String factoryComponentId_p) {
        IContextDescriptor result = (IContextDescriptor)this.readDescriptor(new CreateContextDescriptorOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p), contextId_p));
        return result;
    }

    public ITaskFactoryDescriptor readTaskFactory(String taskFactoryId_p, String factoryComponentId_p) {
        ITaskFactoryDescriptor result = (ITaskFactoryDescriptor)this.readDescriptor(new CreateTaskFactoryDescriptorOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p), taskFactoryId_p));
        return result;
    }

    public IDescriptor readPatternLibraries(String fcId_p) {
        return null;
    }

    public IDescriptor readMappings(String factoryComponentId_p) {
        IDescriptor result = this.readDescriptor(new CreateMappingDescriptorOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p)));
        return result;
    }

    public IContractElementReferenceDescriptor readContractElementReference(String contractReferenceId_p, String factoryComponentId_p) {
        IContractElementReferenceDescriptor result = (IContractElementReferenceDescriptor)this.readDescriptor(new CreateContractElementReferenceOperation(EgfPdeActivator.getDefault().getFile(factoryComponentId_p), contractReferenceId_p));
        return result;
    }

    protected IDescriptor readDescriptor(CreateDescriptorOperation createDescriptorOperation_p) {
        IDescriptor result = super.readDescriptor(createDescriptorOperation_p);
        if (result != null) {
            ((AbstractDescriptor)result).setFactoryComponentReader((IFactoryComponentReader)this);
        }
        return result;
    }
}

