/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.fprod.tasks;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.fprod.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.collector.PatternCollector;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.fprod.Messages;
import org.eclipse.egf.pattern.fprod.tasks.AbstractPatternTask;
import org.eclipse.emf.ecore.EObject;

public class PatternTask
extends AbstractPatternTask {
    private final LinkedHashSet<Pattern> patterns = new LinkedHashSet();

    public void preExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        String patternId = (String)context.getInputValue((Object)"pattern.id", String.class);
        HashSet<String> ids = new HashSet<String>();
        ids.add(patternId);
        Map patternElements = this.helper.getPatternElements(ids);
        if (patternElements.isEmpty()) {
            throw new InvocationException(Messages.bind((String)Messages.Missing_pattern_error1, (Object)patternId));
        }
        PatternElement patternElement = (PatternElement)patternElements.get(patternId);
        PatternCollector.INSTANCE.collect((EObject[])new PatternElement[]{patternElement}, this.patterns);
    }

    public void doExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        try {
            PatternContext ctx = this.createPatternContext(context);
            this.readContext(context, ctx);
            for (Pattern pattern : this.patterns) {
                PatternExtension extension = ExtensionHelper.getExtension((PatternNature)pattern.getNature());
                String reason = extension.canExecute(pattern);
                if (reason == null) {
                    extension.createEngine(pattern).execute(ctx);
                    continue;
                }
                throw new InvocationException(reason);
            }
            this.writeContext(context, ctx);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new InvocationException((Throwable)e);
        }
        catch (PatternException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        super.postExecute(context, monitor);
        this.patterns.clear();
    }
}

