/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.helper.ActivityCycleFinder;
import org.eclipse.egf.model.types.TypeAbstractClass;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.IActivityProductionContext;
import org.eclipse.egf.producer.internal.context.ActivityProductionContext;
import org.eclipse.egf.producer.internal.manager.ModelElementManager;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.manager.IInvocationManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public abstract class ActivityManager
extends ModelElementManager
implements IActivityManager {
    public ActivityManager(Activity activity) throws InvocationException {
        super((ModelElement)activity);
        ActivityCycleFinder finder = new ActivityCycleFinder(activity);
        ModelElement element = finder.getFirstRepetition();
        if (element != null) {
            throw new InvocationException(NLS.bind((String)"Activity cycle detected in ''{0}''", (Object)EMFHelper.getText((Object)element)));
        }
    }

    public ActivityManager(Bundle bundle, Activity activity) throws InvocationException {
        super(bundle, (ModelElement)activity);
        ActivityCycleFinder finder = new ActivityCycleFinder(activity);
        ModelElement element = finder.getFirstRepetition();
        if (element != null) {
            throw new InvocationException(NLS.bind((String)"Activity cycle detected in ''{0}''", (Object)EMFHelper.getText((Object)element)));
        }
    }

    public ActivityManager(IInvocationManager parent, Activity activity) throws InvocationException {
        super(parent, (ModelElement)activity);
    }

    public Activity getElement() {
        return (Activity)super.getElement();
    }

    public IActivityProductionContext getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    public IInvocationManager getParent() {
        return (IInvocationManager)super.getParent();
    }

    protected abstract ActivityProductionContext getInternalProductionContext() throws InvocationException;

    protected BasicDiagnostic canInvokeElement() throws InvocationException {
        BasicDiagnostic diagnostic = ActivityManager.getDiagnostic((ModelElement)this.getElement());
        BasicDiagnostic containerDiagnostic = null;
        for (ActivityContract contract : this.getElement().getActivityContracts(ContractMode.IN)) {
            Object value;
            block5: {
                if (!contract.isMandatory()) continue;
                value = null;
                try {
                    value = this.getInternalProductionContext().getInputValue(contract.getName(), contract.getType().getType());
                }
                catch (InvocationException ie) {
                    if (ie.getCause() == null) break block5;
                    throw ie;
                }
            }
            if (value != null) continue;
            if (containerDiagnostic == null) {
                containerDiagnostic = ActivityManager.getDiagnostic((ModelElement)contract.getActivityContractContainer());
            }
            containerDiagnostic.add((Diagnostic)new BasicDiagnostic(4, EGFProducerPlugin.getDefault().getPluginID(), 0, NLS.bind((String)"ActivityContract is mandatory for ''{0}''", (Object)EMFHelper.getText((Object)contract)), new Object[]{contract}));
        }
        if (containerDiagnostic != null) {
            diagnostic.add(containerDiagnostic);
        }
        return diagnostic;
    }

    public void initializeContext() throws InvocationException {
        ActivityProductionContext context = this.getInternalProductionContext();
        context.clear();
        for (ActivityContract contract : this.getElement().getActivityContracts()) {
            if (contract.getType() == null) continue;
            if (contract.getType() instanceof TypeAbstractClass) {
                try {
                    Object object = null;
                    String fqcn = ((TypeAbstractClass)contract.getType()).getValue();
                    if (fqcn != null && fqcn.trim().length() != 0 && (object = BundleHelper.instantiate((String)fqcn.trim(), (Bundle)this.getBundle())) == null) {
                        throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)contract.getType().getValue(), (Object)this.getBundle().getSymbolicName()), null)));
                    }
                    if (contract.getMode() == ContractMode.IN) {
                        context.addInputData(contract, contract.getType().getType(), object);
                        continue;
                    }
                    if (contract.getMode() == ContractMode.OUT) {
                        context.addOutputData(contract, contract.getType().getType(), null);
                        continue;
                    }
                    if (contract.getMode() != ContractMode.IN_OUT) continue;
                    context.addInputData(contract, contract.getType().getType(), object);
                    context.addOutputData(contract, contract.getType().getType(), object);
                    continue;
                }
                catch (Throwable t) {
                    throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)contract.getType().getValue()), t)));
                }
            }
            if (contract.getMode() == ContractMode.IN) {
                context.addInputData(contract, contract.getType().getType(), contract.getType().getValue());
                continue;
            }
            if (contract.getMode() == ContractMode.OUT) {
                context.addOutputData(contract, contract.getType().getType(), null);
                continue;
            }
            if (contract.getMode() != ContractMode.IN_OUT) continue;
            context.addInputData(contract, contract.getType().getType(), contract.getType().getValue());
            context.addOutputData(contract, contract.getType().getType(), contract.getType().getValue());
        }
    }
}

