/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.ActivityProductionContextProducer;
import org.eclipse.egf.producer.context.IFactoryComponentProductionContext;
import org.eclipse.egf.producer.internal.context.FactoryComponentProductionContext;
import org.eclipse.egf.producer.internal.context.ProducerContextFactory;
import org.eclipse.egf.producer.internal.manager.ActivityManager;
import org.eclipse.egf.producer.manager.IFactoryComponentManager;
import org.eclipse.egf.producer.manager.IInvocationManager;
import org.eclipse.egf.producer.manager.IOrchestrationManager;
import org.eclipse.egf.producer.manager.OrchestrationManagerProducer;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.UniqueEList;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentManager
extends ActivityManager
implements IFactoryComponentManager {
    private IOrchestrationManager _orchestrationManager;

    public FactoryComponentManager(FactoryComponent factoryComponent) throws InvocationException {
        super((Activity)factoryComponent);
    }

    public FactoryComponentManager(Bundle bundle, FactoryComponent factoryComponent) throws InvocationException {
        super(bundle, (Activity)factoryComponent);
    }

    public FactoryComponentManager(IInvocationManager parent, FactoryComponent factoryComponent) throws InvocationException {
        super(parent, (Activity)factoryComponent);
    }

    @Override
    public FactoryComponent getElement() {
        return (FactoryComponent)super.getElement();
    }

    @Override
    public IFactoryComponentProductionContext getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    @Override
    public FactoryComponentProductionContext getInternalProductionContext() throws InvocationException {
        if (this._productionContext == null) {
            if (this.getParent() != null) {
                ActivityProductionContextProducer producer = null;
                try {
                    producer = EGFProducerPlugin.getActivityProductionContextProducer(this.getParent().getProductionContext());
                }
                catch (Throwable t) {
                    throw new InvocationException(t);
                }
                this._productionContext = producer.createActivityProductionContext(this.getParent().getProductionContext(), (Activity)this.getElement(), this.getProjectBundleSession());
            } else {
                this._productionContext = ProducerContextFactory.createContext(this.getElement(), this.getProjectBundleSession());
            }
        }
        return (FactoryComponentProductionContext)this._productionContext;
    }

    public IOrchestrationManager getOrchestrationManager() throws InvocationException {
        if (this._orchestrationManager == null && this.getElement().getOrchestration() != null) {
            OrchestrationManagerProducer producer = null;
            try {
                producer = EGFProducerPlugin.getOrchestrationProducer(this.getElement().getOrchestration());
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
            this._orchestrationManager = producer.createOrchestrationManager(this, this.getElement().getOrchestration());
        }
        return this._orchestrationManager;
    }

    @Override
    public List<Activity> getActivities() throws InvocationException {
        UniqueEList activities = new UniqueEList();
        activities.add(this.getElement());
        if (this.getOrchestrationManager() != null) {
            activities.addAll(this.getOrchestrationManager().getActivities());
        }
        return activities;
    }

    @Override
    public void dispose() throws InvocationException {
        super.dispose();
        if (this.getOrchestrationManager() != null) {
            this.getOrchestrationManager().dispose();
        }
    }

    @Override
    public Diagnostic canInvoke() throws InvocationException {
        BasicDiagnostic diagnostic = this.canInvokeElement();
        if (this.getOrchestrationManager() != null) {
            diagnostic.add(this.getOrchestrationManager().canInvoke());
        }
        return diagnostic;
    }

    @Override
    public void initializeContext() throws InvocationException {
        super.initializeContext();
        if (this.getOrchestrationManager() != null) {
            this.getOrchestrationManager().initializeContext();
        }
    }

    public int getSteps() throws InvocationException {
        if (this.getOrchestrationManager() != null) {
            return this.getOrchestrationManager().getSteps();
        }
        return 0;
    }

    public Diagnostic invoke(IProgressMonitor monitor) throws InvocationException {
        IOrchestrationManager orchestrationManager;
        BasicDiagnostic diagnostic = this.canInvokeElement();
        if (diagnostic.getSeverity() != 4 && (orchestrationManager = this.getOrchestrationManager()) != null) {
            diagnostic.add(orchestrationManager.invoke(monitor));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        return diagnostic;
    }
}

