/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.strategy;

import java.util.Collection;
import java.util.List;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.strategy.Strategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStrategy
implements Strategy {
    protected PatternElement[] patternElements;

    @Override
    public void setPatternElements(List<PatternElement> patterns) {
        this.patternElements = patterns.toArray(new PatternElement[patterns.size()]);
    }

    protected void doExecute(Collection<Pattern> patterns, PatternContext context) throws ExtensionHelper.MissingExtensionException, PatternException {
        for (Pattern pattern : patterns) {
            PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
            String canExecute = extension.canExecute(pattern);
            if (canExecute != null) {
                throw new PatternException(canExecute);
            }
            extension.createEngine(pattern).execute(context);
        }
    }
}

