/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.PatternPreferences;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.jet.JetPreferences;
import org.eclipse.egf.pattern.jet.Messages;
import org.eclipse.egf.pattern.jet.engine.JetAssemblyHelper;
import org.eclipse.egf.pattern.jet.engine.JetNatureHelper;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.emf.codegen.jet.JETCompiler;

public class JetEngine
extends PatternEngine {
    public JetEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void execute(PatternContext context) throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        String templateClassName = JetNatureHelper.getTemplateClassName(pattern);
        if (templateClassName == null) {
            throw new IllegalStateException(Messages.assembly_error1);
        }
        try {
            Class templateClass = context.getBundle(this.getBundleId()).loadClass(templateClassName);
            Method method = templateClass.getMethod("generate", Object.class);
            Object template = templateClass.newInstance();
            method.invoke(template, context);
        }
        catch (InvocationTargetException e) {
            throw new PatternException(e.getCause());
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        JetAssemblyHelper helper = new JetAssemblyHelper(this.getPattern());
        String templatecontent = helper.visit();
        String templateURI = "Pattern_" + pattern.getName() + " (" + pattern.getID() + ")";
        try {
            JETCompiler compiler = new JETCompiler(templateURI, (InputStream)new ByteArrayInputStream(templatecontent.getBytes()), JetPreferences.getEncoding());
            compiler.parse();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            compiler.generate((OutputStream)outStream);
            String targetClassName = JetNatureHelper.getTemplateClassName(pattern);
            IPath outputPath = this.computeFilePath(targetClassName);
            IPlatformFcore platformFcore = PatternHelper.getPlatformFcore((PatternElement)this.getPattern());
            if (platformFcore == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error4, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            IProject project = platformFcore.getPlatformBundle().getProject();
            if (project == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            FileHelper.setContent((IFile)project.getFile(outputPath), (String)this.getContent(new String(outStream.toByteArray())));
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private String getContent(String content) {
        String local;
        StringBuilder builder = new StringBuilder(content.length() + 500);
        int startIndex = content.indexOf("//Start of work");
        int endIndex = content.indexOf("//End of work");
        int insertionIndex = content.lastIndexOf(125);
        if (startIndex == -1 || endIndex == -1 || insertionIndex == -1) {
            return content;
        }
        builder.append(content.substring(0, startIndex));
        Pattern pattern = this.getPattern();
        builder.append("generate(stringBuffer, ctx");
        if (!this.getPattern().getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                builder.append(", ").append(local);
            }
        }
        builder.append(");");
        builder.append(content.substring(endIndex + "//End of work".length(), insertionIndex));
        builder.append("public void generate(final StringBuffer stringBuffer, PatternContext ctx");
        if (!this.getPattern().getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                builder.append(", Object ").append(local);
            }
        }
        builder.append(") {").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append(content.substring(startIndex + "//Start of work".length(), endIndex));
        builder.append("} ").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append(content.substring(insertionIndex));
        return builder.toString();
    }

    private IPath computeFilePath(String classname) {
        String[] names;
        Path result = new Path(PatternPreferences.getGenerationFolderName());
        String[] stringArray = names = classname.split("\\.");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.append(name);
            ++n2;
        }
        result = result.addFileExtension("java");
        return result;
    }
}

