/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import org.eclipse.egf.core.ui.dialogs.TypeInfoRequestorAdapter;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;

public class TypeInfoFilter {
    private final String fText;
    private final ITypeInfoFilterExtension fFilterExtension;
    private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
    private final PatternMatcher fPackageMatcher;
    private final PatternMatcher fNameMatcher;

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        int prefixLength;
        int textLength = text.length();
        if (textLength < (prefixLength = prefix.length())) {
            return false;
        }
        int i = prefixLength - 1;
        while (i >= 0) {
            if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isCamelCasePattern(String pattern) {
        return SearchPattern.validateMatchRule((String)pattern, (int)128) == 128;
    }

    public TypeInfoFilter(String text, ITypeInfoFilterExtension extension) {
        this.fText = text;
        this.fFilterExtension = extension;
        int index = text.lastIndexOf(".");
        if (index == -1) {
            this.fNameMatcher = new PatternMatcher(text);
            this.fPackageMatcher = null;
        } else {
            this.fPackageMatcher = new PatternMatcher(this.evaluatePackagePattern(text.substring(0, index)));
            String name = text.substring(index + 1);
            if (name.length() == 0) {
                name = "*";
            }
            this.fNameMatcher = new PatternMatcher(name);
        }
    }

    private String evaluatePackagePattern(String s) {
        StringBuffer buf = new StringBuffer();
        boolean hasWildCard = false;
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '.') {
                if (!hasWildCard) {
                    buf.append('*');
                }
                hasWildCard = false;
            } else if (ch == '*' || ch == '?') {
                hasWildCard = true;
            }
            buf.append(ch);
            ++i;
        }
        if (!hasWildCard) {
            if (len == 0) {
                buf.append('?');
            }
            buf.append('*');
        }
        return buf.toString();
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        if (!this.fText.startsWith(text)) {
            return false;
        }
        return this.fText.indexOf(46, text.length()) == -1;
    }

    public boolean isCamelCasePattern() {
        int ccMask = 384;
        return (this.fNameMatcher.getMatchKind() & ccMask) != 0;
    }

    public String getPackagePattern() {
        if (this.fPackageMatcher == null) {
            return null;
        }
        return this.fPackageMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        return this.fNameMatcher.getMatchKind();
    }

    public int getPackageFlags() {
        if (this.fPackageMatcher == null) {
            return 0;
        }
        return this.fPackageMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(IType type) {
        return TypeInfoFilter.startsWithIgnoreCase(type.getElementName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(IType type) {
        if (!this.matchesPackage(type) || !this.matchesFilterExtension(type)) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesHistoryElement(IType type) {
        if (!this.matchesPackage(type) || !this.matchesFilterExtension(type)) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesFilterExtension(IType type) {
        if (this.fFilterExtension == null) {
            return true;
        }
        this.fAdapter.setMatch(type);
        return this.fFilterExtension.select((ITypeInfoRequestor)this.fAdapter);
    }

    private boolean matchesName(IType type) {
        if (this.fText.length() == 0) {
            return true;
        }
        return this.fNameMatcher.matches(type.getElementName());
    }

    private boolean matchesPackage(IType type) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.matches(type.getPackageFragment().getElementName());
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String pattern) {
            this(pattern, 387);
        }

        private PatternMatcher(String pattern, int allowedModes) {
            this.initializePatternAndMatchKind(pattern);
            this.fMatchKind &= allowedModes;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String text) {
            switch (this.fMatchKind) {
                case 2: {
                    return this.fStringMatcher.match(text);
                }
                case 0: {
                    return this.fPattern.equalsIgnoreCase(text);
                }
                case 256: {
                    return SearchPattern.camelCaseMatch((String)this.fPattern, (String)text, (boolean)true);
                }
                case 128: {
                    if (SearchPattern.camelCaseMatch((String)this.fPattern, (String)text)) {
                        return true;
                    }
                    return TypeInfoFilter.startsWithIgnoreCase(text, this.fPattern);
                }
            }
            return TypeInfoFilter.startsWithIgnoreCase(text, this.fPattern);
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.fMatchKind = 0;
                this.fPattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (last) {
                    case ' ': 
                    case '<': {
                        this.fPattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        this.fPattern = pattern;
                        break;
                    }
                    default: {
                        this.fPattern = String.valueOf(pattern) + '*';
                    }
                }
                return;
            }
            if (last == '<' || last == ' ') {
                this.fPattern = pattern.substring(0, length - 1);
                this.fMatchKind = SearchPattern.validateMatchRule((String)this.fPattern, (int)256) == 256 ? 256 : 0;
                return;
            }
            if (TypeInfoFilter.isCamelCasePattern(pattern)) {
                this.fMatchKind = 128;
                this.fPattern = pattern;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = pattern;
        }
    }
}

