/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.ecore.EPackageHelper;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class EPackageListener
implements IResourceChangeListener {
    private static final String RESOURCE_SUFFIX = "Package.java";

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            delta.accept((IResourceDeltaVisitor)new ResourceDeltaVisitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logWarning(e);
        }
    }

    private final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && resource.getName().endsWith(EPackageListener.RESOURCE_SUFFIX)) {
                IProject project = resource.getProject();
                ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IResource)resource);
                IType type = unit.findPrimaryType();
                if (type == null || !type.getField("eINSTANCE").exists()) {
                    return false;
                }
                String fullyQualifiedName = type.getFullyQualifiedName();
                try {
                    switch (delta.getKind()) {
                        case 1: 
                        case 4: 
                        case 8: {
                            EPackageHelper.registerPackage(project, fullyQualifiedName);
                            break;
                        }
                        case 2: 
                        case 16: {
                            EPackageHelper.unregisterPackage(project, fullyQualifiedName);
                        }
                    }
                }
                catch (EPackageHelper.RegistrationException e) {
                    Activator.getDefault().logWarning(e);
                }
                return false;
            }
            return true;
        }
    }
}

