/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JavaMethodGenerationHelper {
    private final String bufferName;
    private StringBuilder content;

    public JavaMethodGenerationHelper(String bufferName) {
        this.bufferName = bufferName;
    }

    public void addCallStatement(PatternMethod called) {
        this.content.append("method_").append(called.getName()).append("(ictx.getBuffer(), ictx");
        Pattern pattern = called.getPattern();
        if (!pattern.getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                this.content.append(", ").append(parameter.getName());
            }
        }
        this.content.append(");");
    }

    public void addSignature(PatternMethod called) {
        this.content.append("protected void method_").append(called.getName()).append("(final StringBuffer ").append(this.bufferName).append(", final PatternContext ctx");
        Pattern pattern = called.getPattern();
        if (!pattern.getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                String type = ParameterTypeHelper.INSTANCE.getTypeLiteral(parameter.getType());
                this.content.append(", final ").append(type).append(" ").append(parameter.getName());
            }
        }
        this.content.append(")throws Exception ");
    }

    public void setContent(StringBuilder content) {
        this.content = content;
    }
}

