/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.EGFValidator;
import org.eclipse.egf.model.editor.dialogs.ActivitySelectionDialog;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.ui.EGFProducerUIPlugin;
import org.eclipse.egf.producer.ui.internal.dialogs.ActivityValidationSelectionDialog;
import org.eclipse.egf.producer.ui.internal.ui.ProducerUIImages;
import org.eclipse.egf.producer.ui.l10n.ProducerUIMessages;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunActivityAction
implements IObjectActionDelegate {
    private IPlatformFcore _fcore;
    private Activity _activity;
    private List<Activity> _validates = null;

    public void run(IAction action) {
        this._validates = null;
        if (this._fcore != null) {
            ActivitySelectionDialog activityDialog = new ActivitySelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), this._fcore, false);
            activityDialog.setTitle(ProducerUIMessages.GlobalRunActivityAction_dialogTitle);
            int result = activityDialog.open();
            if (result != 0) {
                return;
            }
            Object[] selection = activityDialog.getResult();
            if (selection == null || selection.length != 1) {
                return;
            }
            this._activity = (Activity)selection[0];
        }
        if (this._activity == null) {
            return;
        }
        final IActivityManager[] activityManager = new IActivityManager[1];
        Throwable throwable = null;
        final int[] ticks = new int[1];
        try {
            ActivityManagerProducer producer = null;
            try {
                producer = EGFProducerPlugin.getActivityManagerProducer((Activity)this._activity);
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
            activityManager[0] = producer.createActivityManager(this._activity);
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                EGFValidator validator;
                Diagnostic validationDiag;
                IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
                String validate = store.getString("org.eclipse.egf.core.validate.model.instances.before.launch");
                List activities = activityManager[0].getActivities();
                int status = this.showValidateDialog(activities, !validate.equals("never"), validate.equals("prompt"));
                if (status != 0) {
                    return;
                }
                if (this._validates != null && this._validates.size() != 0 && (validationDiag = (validator = new EGFValidator(this._validates)).validate()).getSeverity() == 4) {
                    return;
                }
            }
            catch (InvocationException ie) {
                throwable = ie;
            }
        }
        if (throwable == null) {
            try {
                activityManager[0].initializeContext();
                final Diagnostic preInvokeDiag = activityManager[0].canInvoke();
                if (preInvokeDiag.getSeverity() != 0) {
                    if (EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                        EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                            public void run() {
                                EGFValidator.handleDiagnostic((String)ProducerUIMessages._UI_CantInvokeProblems_title, (String)ProducerUIMessages._UI_CantInvokeProblems_message, (Diagnostic)preInvokeDiag);
                            }
                        });
                    }
                    if (preInvokeDiag.getSeverity() == 4) {
                        return;
                    }
                }
            }
            catch (InvocationException ie) {
                throwable = ie;
            }
        }
        if (throwable == null) {
            try {
                ticks[0] = activityManager[0].getSteps();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (throwable == null) {
            WorkspaceJob activityJob = new WorkspaceJob(ProducerUIMessages.GlobalRunActivityAction_label){

                public boolean belongsTo(Object family) {
                    return EGFCorePlugin.FAMILY_MANUAL_BUILD.equals(family);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)EMFHelper.getText((Object)activityManager[0].getElement())), (int)(1000 * ticks[0]));
                        try {
                            try {
                                if (EGFProducerUIPlugin.getDefault().isDebugging()) {
                                    if (ticks[0] == 1) {
                                        EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerUIMessages.Activity_Invocation, (Object)EMFHelper.getText((Object)RunActivityAction.this._activity)));
                                    } else {
                                        EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerUIMessages.Activity_Invocations, (Object)EMFHelper.getText((Object)RunActivityAction.this._activity), (Object)ticks[0]));
                                    }
                                }
                                final Diagnostic diagnostic = activityManager[0].invoke((IProgressMonitor)subMonitor.newChild(1000 * ticks[0], 0));
                                if (subMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                if (diagnostic != null && diagnostic.getSeverity() != 0 && EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                                    EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            EGFValidator.handleDiagnostic((String)ProducerUIMessages._UI_CantInvokeProblems_title, (String)ProducerUIMessages._UI_CantInvokeProblems_message, (Diagnostic)diagnostic);
                                        }
                                    });
                                }
                            }
                            catch (InvocationException ie) {
                                if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                                    throw (CoreException)ie.getCause();
                                }
                                ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie);
                                try {
                                    activityManager[0].dispose();
                                }
                                catch (InvocationException ie2) {
                                    if (ie2.getCause() != null && ie2.getCause() instanceof CoreException) {
                                        throw (CoreException)ie2.getCause();
                                    }
                                    ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie2);
                                }
                                catch (Throwable t) {
                                    throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                                }
                            }
                            catch (Throwable t) {
                                throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                            }
                        }
                        finally {
                            try {
                                activityManager[0].dispose();
                            }
                            catch (InvocationException ie) {
                                if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                                    throw (CoreException)ie.getCause();
                                }
                                ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie);
                            }
                            catch (Throwable t) {
                                throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                            }
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            activityJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            activityJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ProducerUIImages.EGF_RUN_ACTIVITY);
            activityJob.setPriority(30);
            activityJob.setUser(true);
            activityJob.setSystem(false);
            activityJob.schedule();
        }
        if (throwable != null && !(throwable instanceof InterruptedException)) {
            ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)throwable);
        }
    }

    protected Activity getActivitySelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selectedObject == null) {
            return null;
        }
        if (selectedObject instanceof Activity) {
            return (Activity)selectedObject;
        }
        return null;
    }

    protected IPlatformFcore getPlatformFcoreSelection(IStructuredSelection selection) {
        block5: {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject == null) {
                return null;
            }
            if (selectedObject instanceof IResource) {
                IPlatformFcore fcore;
                block6: {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (IResource)((IResource)selectedObject));
                    fcore = EGFCorePlugin.getPlatformFcore((Resource)resource);
                    if (fcore == null) break block5;
                    if (resource.getContents().size() != 1 || !(resource.getContents().get(0) instanceof Activity)) break block6;
                    this._activity = (Activity)resource.getContents().get(0);
                    return null;
                }
                try {
                    return fcore;
                }
                catch (Throwable t) {
                    EGFProducerUIPlugin.getDefault().logError(t);
                }
            }
        }
        return null;
    }

    private int showValidateDialog(List<Activity> activities, boolean validate, boolean prompt) {
        if (validate) {
            if (prompt && activities != null && activities.size() > 0) {
                ActivityValidationSelectionDialog dialog = new ActivityValidationSelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), activities);
                if (dialog.open() == 1) {
                    return 1;
                }
                Object[] objects = dialog.getResult();
                this._validates = new ArrayList<Activity>(objects.length);
                int i = 0;
                while (i < objects.length) {
                    this._validates.add((Activity)objects[i]);
                    ++i;
                }
            } else {
                this._validates = activities;
            }
        }
        return 0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._activity = null;
        if (selection instanceof IStructuredSelection) {
            this._activity = this.getActivitySelection((IStructuredSelection)selection);
            if (this._activity == null) {
                this._fcore = this.getPlatformFcoreSelection((IStructuredSelection)selection);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart activePart) {
    }
}

