/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.helper.EclipseBuilderHelper;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertPluginProjectOperation
extends ConvertProjectOperation {
    public static final String F_MANIFEST = "MANIFEST.MF";
    public static final String MANIFEST_FOLDER_NAME = "META-INF/";
    public static final String F_MANIFEST_FP = "META-INF/MANIFEST.MF";
    public static final String JET_NATURE_ID = "org.eclipse.jet.jet2Nature";
    public static final String F_PLUGIN = "plugin.xml";
    public static final String F_PROPERTIES = ".properties";
    public static final String F_BUILD = "build.properties";
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "transform";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.transform";
    private int K_SOURCE = 1;
    private boolean _hasJetNature;
    private IProject _project;
    private IPlatformBundle platformBundle;

    public ConvertPluginProjectOperation(IProject project, IPlatformBundle platformBundle) {
        super(project, false, false);
        this._project = project;
        this.platformBundle = platformBundle;
    }

    public List<String> addDependencies() {
        return super.addDependencies();
    }

    public List<String> addSourceFolders() {
        return super.addSourceFolders();
    }

    public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IPluginModelBase model;
        String[] natureIds;
        super.execute(monitor);
        this._hasJetNature = false;
        IProjectDescription description = this._project.getDescription();
        String[] stringArray = natureIds = description.getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureID = stringArray[n2];
            if (natureID.equals(JET_NATURE_ID)) {
                this._hasJetNature = true;
            }
            ++n2;
        }
        if (!this._hasJetNature) {
            EclipseBuilderHelper.addNature((IProjectDescription)description, (String)JET_NATURE_ID, (IProgressMonitor)monitor);
        }
        this._project.setDescription(description, monitor);
        IPluginBase pluginBase = this.platformBundle.getPluginBase();
        IPluginExtensionPoint[] extensionPoints = pluginBase.getExtensionPoints();
        IPluginExtension[] extensions = pluginBase.getExtensions();
        IPluginImport[] imports = pluginBase.getImports();
        IPluginLibrary[] libraries = pluginBase.getLibraries();
        IProject project = this.platformBundle.getProject();
        IFile pluginFile = project.getFile(F_PLUGIN);
        IFile plugin = this._project.getFile(F_PLUGIN);
        if (!plugin.exists() && pluginFile.exists()) {
            pluginFile.copy(plugin.getFullPath(), true, monitor);
        }
        if ((model = PluginRegistry.findModel((IProject)this._project)) instanceof BundlePluginModel) {
            BundlePluginModel bundlePluginModel = (BundlePluginModel)model;
            WorkspaceBundleModel workspaceBundleModel = (WorkspaceBundleModel)bundlePluginModel.getBundleModel();
            WorkspaceExtensionsModel workspaceExtensionModel = (WorkspaceExtensionsModel)((BundlePluginModel)model).getExtensionsModel();
            workspaceExtensionModel.setEditable(true);
            workspaceBundleModel.setEditable(true);
            IBundle bundle = workspaceBundleModel.getBundle();
            IPluginBase templatePluginBase = model.getPluginBase(false);
            this.updateManifest(bundle);
            IPluginExtensionPoint[] iPluginExtensionPointArray = extensionPoints;
            int n3 = extensionPoints.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginExtensionPoint extensionPoint = iPluginExtensionPointArray[n4];
                templatePluginBase.add(extensionPoint);
                ++n4;
            }
            iPluginExtensionPointArray = extensions;
            n3 = extensions.length;
            n4 = 0;
            while (n4 < n3) {
                IPluginExtensionPoint userExtension = iPluginExtensionPointArray[n4];
                userExtension.getPoint().equals(EXTENSION_POINT_ID);
                ++n4;
            }
            iPluginExtensionPointArray = imports;
            n3 = imports.length;
            n4 = 0;
            while (n4 < n3) {
                IPluginExtensionPoint pluginImport = iPluginExtensionPointArray[n4];
                templatePluginBase.add((IPluginImport)pluginImport);
                ++n4;
            }
            iPluginExtensionPointArray = libraries;
            n3 = libraries.length;
            n4 = 0;
            while (n4 < n3) {
                IPluginExtensionPoint librarie = iPluginExtensionPointArray[n4];
                templatePluginBase.add((IPluginLibrary)librarie);
                ++n4;
            }
            workspaceBundleModel.save();
            workspaceExtensionModel.save();
            workspaceExtensionModel.setEditable(false);
            workspaceBundleModel.setEditable(false);
        }
        this.addLinkedSource(project, this._project, monitor);
    }

    protected void fireStructureChanged(IPluginObject child, WorkspaceExtensionsModel workspaceExtensionModel, int changeType) {
        WorkspaceExtensionsModel model = workspaceExtensionModel;
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            ModelChangedEvent e = new ModelChangedEvent((IModelChangeProvider)model, changeType, new Object[]{child}, null);
            if (model.isEditable() && model instanceof IModelChangeProvider) {
                IModelChangeProvider provider = (IModelChangeProvider)model;
                provider.fireModelChanged((IModelChangedEvent)e);
            }
        }
    }

    private void addLinkedSource(IProject userProject, IProject tempProject, IProgressMonitor monitor) throws CoreException {
        new ArrayList();
        IJavaProject userJavaProject = JavaCore.create((IProject)userProject);
        IJavaProject tempJavaProject = JavaCore.create((IProject)tempProject);
        IPackageFragmentRoot[] allPackageFragmentRoots = userJavaProject.getAllPackageFragmentRoots();
        CPListElement[] existing = CPListElement.createFromExisting((IJavaProject)tempJavaProject);
        ArrayList<CPListElement> cpListElements = new ArrayList<CPListElement>();
        CPListElement[] cPListElementArray = existing;
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            CPListElement elment = cPListElementArray[n2];
            cpListElements.add(elment);
            ++n2;
        }
        if (allPackageFragmentRoots != null && allPackageFragmentRoots.length > 0) {
            cPListElementArray = allPackageFragmentRoots;
            n = allPackageFragmentRoots.length;
            n2 = 0;
            while (n2 < n) {
                CPListElement packageFragmentRoot = cPListElementArray[n2];
                int kind = packageFragmentRoot.getKind();
                if (kind == this.K_SOURCE) {
                    IClasspathEntry rawClasspathEntry = packageFragmentRoot.getRawClasspathEntry();
                    IPath fullPath = packageFragmentRoot.getResource().getLocation();
                    IPath path = rawClasspathEntry.getPath();
                    path.removeLastSegments(path.segmentCount() - 1);
                    IPath pathFolder = path.removeFirstSegments(path.segmentCount() - 1);
                    pathFolder = this.createFolder(fullPath, pathFolder.toString(), tempProject, monitor);
                    CPListElement newEntrie = new CPListElement(tempJavaProject, 3);
                    newEntrie.setLinkTarget(fullPath);
                    newEntrie.setPath(pathFolder);
                    newEntrie.setExported(true);
                    cpListElements.add(newEntrie);
                }
                ++n2;
            }
        }
        BuildPathsBlock.flush(cpListElements, (IPath)tempJavaProject.getOutputLocation(), (IJavaProject)tempJavaProject, null, (IProgressMonitor)monitor);
    }

    private IPath createFolder(IPath path, String fName, IProject tempProject, IProgressMonitor monitor) throws CoreException {
        String folderName = fName;
        IFolder tempFolder = tempProject.getFolder(folderName);
        IPath fullPath = tempFolder.getFullPath();
        if (tempFolder.exists()) {
            folderName = "temp" + folderName;
            fullPath = this.createFolder(path, folderName, tempProject, monitor);
        }
        return fullPath;
    }

    private void updateManifest(IBundle bundle) {
        bundle.getHeader("Bundle-SymbolicName");
        String projectName = this._project.getName();
        if (projectName.startsWith(".")) {
            projectName = projectName.substring(1, projectName.length() - 1);
        }
        bundle.setHeader("Bundle-SymbolicName", String.valueOf(projectName) + ";singleton:=true");
    }
}

