/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.TypeInfoFilter;
import org.eclipse.egf.core.ui.dialogs.TypeInfoRequestorAdapter;
import org.eclipse.egf.core.ui.dialogs.TypeNameMatchLabelProvider;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoImageProvider;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.core.ui.dialogs.TypeSelectionDialog";
    private IProject _project;
    private Class<?> _clazz;
    private final TypeInfoUtil _infoUtil;
    private int _filterVersion = 0;
    private TypeItemsFilter _filter;
    private final ITypeInfoFilterExtension _filterExtension;

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public TypeSelectionDialog(Shell parentShell, IProject project, Class<?> clazz, String current, TypeSelectionExtension extension, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        Assert.isNotNull((Object)project);
        Assert.isNotNull(clazz);
        this._project = project;
        this._clazz = clazz;
        this._infoUtil = new TypeInfoUtil(null);
        this._filterExtension = extension == null ? null : extension.getFilterExtension();
        this.setTitle(CoreUIMessages._UI_TypeSelection_label);
        this.setMessage(NLS.bind((String)CoreUIMessages._UI_SelectType, (Object)this._clazz.getName()));
        this.setListLabelProvider((ILabelProvider)new TypeItemLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new TypeItemDetailsLabelProvider(this._infoUtil));
        this.setSelectionHistory(current);
        this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)BundleHelper.getBundleId((IProject)this._project)));
    }

    private void setSelectionHistory(String current) {
        if (current == null || current.trim().length() == 0) {
            return;
        }
        IJavaProject javaProject = null;
        try {
            try {
                try {
                    if (this._project.isAccessible() && this._project.hasNature("org.eclipse.jdt.core.javanature")) {
                        javaProject = JavaCore.create((IProject)this._project);
                    }
                }
                catch (CoreException e) {
                    EGFCoreUIPlugin.getDefault().logError(e);
                }
                if (javaProject != null) {
                    TypeSelectionHistory history = new TypeSelectionHistory();
                    IType type = javaProject.findType(current.trim());
                    if (type != null) {
                        history.accessed(type);
                    }
                    this.setSelectionHistory(history);
                }
            }
            catch (JavaModelException jme) {
                EGFCoreUIPlugin.getDefault().logError(jme);
                try {
                    if (javaProject != null) {
                        javaProject.close();
                    }
                }
                catch (JavaModelException jme2) {
                    EGFCoreUIPlugin.getDefault().logError(jme2);
                }
            }
        }
        finally {
            try {
                if (javaProject != null) {
                    javaProject.close();
                }
            }
            catch (JavaModelException jme) {
                EGFCoreUIPlugin.getDefault().logError(jme);
            }
        }
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        this._filter = new TypeItemsFilter(this._filterExtension);
        return this._filter;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        block33: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)CoreUIMessages.TypeSelectionDialog_findTypeHierarchy, (Object)this._clazz.getName()), (int)1000);
            UniqueEList types = new UniqueEList();
            TypeItemsFilter typeSearchFilter = (TypeItemsFilter)itemsFilter;
            IJavaProject javaProject = null;
            try {
                ITypeHierarchy typeHierarchy;
                String bundleId;
                try {
                    if (this._project.isAccessible() && this._project.hasNature("org.eclipse.jdt.core.javanature")) {
                        javaProject = JavaCore.create((IProject)this._project);
                    }
                }
                catch (CoreException e) {
                    EGFCoreUIPlugin.getDefault().logError(e);
                }
                if (javaProject == null) break block33;
                IType classType = javaProject.findType(this._clazz.getName(), (IProgressMonitor)subMonitor.newChild(200, 0));
                if (classType == null) {
                    return;
                }
                if (!TypeFilter.isFiltered((IType)classType) && Flags.isPublic((int)classType.getFlags()) && !Flags.isInterface((int)classType.getFlags()) && !Flags.isAbstract((int)classType.getFlags()) && (bundleId = BundleHelper.getBundleId((IProject)classType.getJavaProject().getProject())) != null && typeSearchFilter.matchesFilterExtension(classType)) {
                    types.add(classType);
                }
                if ((typeHierarchy = classType.newTypeHierarchy(javaProject, (IProgressMonitor)subMonitor.newChild(300, 0))) == null) {
                    return;
                }
                try {
                    IType[] iTypeArray = typeHierarchy.getAllSubtypes(classType);
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bundleId2;
                        IType type = iTypeArray[n2];
                        if (!TypeFilter.isFiltered((IType)type) && Flags.isPublic((int)type.getFlags()) && !Flags.isInterface((int)type.getFlags()) && !Flags.isAbstract((int)type.getFlags()) && (bundleId2 = BundleHelper.getBundleId((IProject)type.getJavaProject().getProject())) != null && typeSearchFilter.matchesFilterExtension(type)) {
                            types.add(type);
                        }
                        ++n2;
                    }
                    IJavaElement[] javaElements = new IJavaElement[]{javaProject};
                    JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
                    IJavaSearchScope scope = factory.createJavaSearchScope(javaElements, 15);
                    String scopeDescription = factory.getSelectionScopeDescription(javaElements, 15);
                    PatternQuerySpecification querySpec = new PatternQuerySpecification(classType.getElementName(), 0, true, 5, scope, scopeDescription);
                    JavaSearchQuery searchJob = new JavaSearchQuery((QuerySpecification)querySpec);
                    searchJob.run((IProgressMonitor)subMonitor.newChild(300, 0));
                    JavaSearchResult result = (JavaSearchResult)searchJob.getSearchResult();
                    Object[] objectArray = result.getElements();
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String bundleId3;
                        IType type;
                        Object object = objectArray[n4];
                        if (object instanceof IType && !TypeFilter.isFiltered((IType)(type = (IType)object)) && Flags.isPublic((int)type.getFlags()) && !Flags.isInterface((int)type.getFlags()) && !Flags.isAbstract((int)type.getFlags()) && (bundleId3 = BundleHelper.getBundleId((IProject)type.getJavaProject().getProject())) != null && typeSearchFilter.matchesFilterExtension(type)) {
                            types.add(type);
                        }
                        ++n4;
                    }
                    for (IType type : types) {
                        contentProvider.add((Object)type, (FilteredItemsSelectionDialog.ItemsFilter)typeSearchFilter);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
                catch (Throwable t) {
                    ThrowableHandler.handleThrowable((String)EGFCoreUIPlugin.getDefault().getPluginID(), (Throwable)t);
                    return;
                }
            }
            finally {
                try {
                    if (javaProject != null) {
                        javaProject.close();
                    }
                }
                catch (JavaModelException jme) {
                    EGFCoreUIPlugin.getDefault().logError(jme);
                }
                monitor.done();
            }
        }
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new TypeFiltersPreferencesAction());
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = EGFCoreUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = EGFCoreUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPlatformFcore) {
            IPlatformFcore fc = (IPlatformFcore)item;
            return fc.getURI().toString();
        }
        return null;
    }

    protected Comparator<IType> getItemsComparator() {
        return new TypeItemsComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, EGFCoreUIPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
    }

    public void triggerSearch() {
        ++this._filterVersion;
        this.applyFilter();
    }

    protected void setResult(List newResult) {
        ArrayList<IType> resultToReturn = new ArrayList<IType>();
        int i = 0;
        while (i < newResult.size()) {
            if (newResult.get(i) instanceof IType) {
                IType type = (IType)newResult.get(i);
                if (type.exists()) {
                    resultToReturn.add(type);
                } else {
                    IPackageFragmentRoot root = TypeNameMatchLabelProvider.getPackageFragmentRoot(type);
                    String containerName = JavaElementLabels.getElementLabel((IJavaElement)root, (long)0x20000000000L);
                    String message = NLS.bind((String)CoreUIMessages._UI_FilteredTypesSelectionDialog_dialogMessage, (Object[])new String[]{TypeNameMatchLabelProvider.getText(type, 1), containerName});
                    MessageDialog.openError((Shell)this.getShell(), (String)CoreUIMessages._UI_TypeSelection_label, (String)message);
                    this.getSelectionHistory().remove((Object)type);
                }
            }
            ++i;
        }
        super.setResult(resultToReturn);
    }

    private class TypeFiltersPreferencesAction
    extends Action {
        public TypeFiltersPreferencesAction() {
            super(JavaUIMessages.FilteredTypesSelectionDialog_TypeFiltersPreferencesAction_label);
        }

        public void run() {
            String typeFilterID = "org.eclipse.jdt.ui.preferences.TypeFilterPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)TypeSelectionDialog.this.getShell(), (String)typeFilterID, (String[])new String[]{typeFilterID}, null).open();
            TypeSelectionDialog.this.triggerSearch();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeInfoUtil {
        private final ITypeInfoImageProvider fProviderExtension;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private final Map<String, String> fLib2Name = new HashMap<String, String>();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeInfoUtil(ITypeInfoImageProvider extension) {
            this.fProviderExtension = extension;
            ArrayList<String> locations = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IVMInstallType installType, List<String> locations, List<String> labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toOSString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return NLS.bind((String)CoreUIMessages._UI_FilteredTypesSelectionDialog_library_name_format, (Object)name);
        }

        public String getQualifiedText(IType type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getElementName());
            String containerName = TypeNameMatchLabelProvider.getTypeContainerName(type);
            result.append(JavaElementLabels.CONCAT_STRING);
            if (containerName.length() > 0) {
                result.append(containerName);
            } else {
                result.append(JavaUIMessages.FilteredTypesSelectionDialog_default_package);
            }
            return result.toString();
        }

        public String getFullyQualifiedText(IType type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getElementName());
            String containerName = TypeNameMatchLabelProvider.getTypeContainerName(type);
            if (containerName.length() > 0) {
                result.append(JavaElementLabels.CONCAT_STRING);
                result.append(containerName);
            }
            result.append(JavaElementLabels.CONCAT_STRING);
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public String getQualificationText(IType type) {
            StringBuffer result = new StringBuffer();
            String containerName = TypeNameMatchLabelProvider.getTypeContainerName(type);
            if (containerName.length() > 0) {
                result.append(containerName);
                result.append(JavaElementLabels.CONCAT_STRING);
            }
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public ImageDescriptor getContributedImageDescriptor(Object element) {
            IType type = (IType)element;
            if (this.fProviderExtension != null) {
                this.fAdapter.setMatch(type);
                return this.fProviderExtension.getImageDescriptor((ITypeInfoRequestor)this.fAdapter);
            }
            return null;
        }

        private String getContainerName(IType type) {
            IPackageFragmentRoot root = TypeNameMatchLabelProvider.getPackageFragmentRoot(type);
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)root, (long)0x30000000000L, (StringBuffer)buf);
            return buf.toString();
        }
    }

    private static class TypeItemDetailsLabelProvider
    extends LabelProvider {
        private final TypeInfoUtil fTypeInfoUtil;

        public TypeItemDetailsLabelProvider(TypeInfoUtil typeInfoUtil) {
            this.fTypeInfoUtil = typeInfoUtil;
        }

        public Image getImage(Object element) {
            if (element instanceof IType) {
                return TypeNameMatchLabelProvider.getImage((IType)element, 32);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IType) {
                return BasicElementLabels.getJavaElementName((String)this.fTypeInfoUtil.getQualificationText((IType)element));
            }
            return super.getText(element);
        }
    }

    private class TypeItemLabelProvider
    extends LabelProvider
    implements ILabelDecorator,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private boolean fContainerInfo = false;
        private LocalResourceManager fImageManager = new LocalResourceManager(JFaceResources.getResources());
        private Font fBoldFont;
        private StyledString.Styler fBoldStyler = this.createBoldStyler();
        private StyledString.Styler fBoldQualifierStyler = this.createBoldQualifierStyler();

        public void dispose() {
            super.dispose();
            this.fImageManager.dispose();
            if (this.fBoldFont != null) {
                this.fBoldFont.dispose();
                this.fBoldFont = null;
            }
        }

        public Image getImage(Object element) {
            if (!(element instanceof IType)) {
                return super.getImage(element);
            }
            ImageDescriptor contributedImageDescriptor = TypeSelectionDialog.this._infoUtil.getContributedImageDescriptor(element);
            if (contributedImageDescriptor == null) {
                return TypeNameMatchLabelProvider.getImage((IType)element, 16);
            }
            return this.fImageManager.createImage(contributedImageDescriptor);
        }

        public String getText(Object element) {
            if (!(element instanceof IType)) {
                return super.getText(element);
            }
            IType type = (IType)element;
            if (this.fContainerInfo && TypeSelectionDialog.this.isDuplicateElement(element)) {
                return BasicElementLabels.getJavaElementName((String)TypeSelectionDialog.this._infoUtil.getFullyQualifiedText(type));
            }
            if (!this.fContainerInfo && TypeSelectionDialog.this.isDuplicateElement(element)) {
                return BasicElementLabels.getJavaElementName((String)TypeSelectionDialog.this._infoUtil.getQualifiedText(type));
            }
            return BasicElementLabels.getJavaElementName((String)type.getElementName());
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof IType)) {
                return null;
            }
            if (TypeSelectionDialog.this.isDuplicateElement(element)) {
                return BasicElementLabels.getJavaElementName((String)TypeSelectionDialog.this._infoUtil.getFullyQualifiedText((IType)element));
            }
            return BasicElementLabels.getJavaElementName((String)TypeSelectionDialog.this._infoUtil.getQualifiedText((IType)element));
        }

        public StyledString getStyledText(Object element) {
            String namePattern;
            String text = this.getText(element);
            StyledString string = new StyledString(text);
            int index = text.indexOf(JavaElementLabels.CONCAT_STRING);
            String string2 = namePattern = TypeSelectionDialog.this._filter != null ? TypeSelectionDialog.this._filter.getNamePattern() : null;
            if (namePattern != null && !"*".equals(namePattern)) {
                String typeName = index == -1 ? text : text.substring(0, index);
                int[] matchingRegions = org.eclipse.jdt.core.search.SearchPattern.getMatchingRegions((String)namePattern, (String)typeName, (int)TypeSelectionDialog.this._filter.getMatchRule());
                this.markMatchingRegions(string, 0, matchingRegions, this.fBoldStyler);
            }
            if (index != -1) {
                String packagePattern;
                string.setStyle(index, text.length() - index, StyledString.QUALIFIER_STYLER);
                String string3 = packagePattern = TypeSelectionDialog.this._filter != null ? TypeSelectionDialog.this._filter.getPackagePattern() : null;
                if (packagePattern != null && !"*".equals(packagePattern)) {
                    int endIndex = text.indexOf(JavaElementLabels.CONCAT_STRING, index += JavaElementLabels.CONCAT_STRING.length());
                    String packageName = endIndex == -1 ? text.substring(index) : text.substring(index, endIndex);
                    int[] matchingRegions = org.eclipse.jdt.core.search.SearchPattern.getMatchingRegions((String)packagePattern, (String)packageName, (int)TypeSelectionDialog.this._filter.getPackageFlags());
                    this.markMatchingRegions(string, index, matchingRegions, this.fBoldQualifierStyler);
                }
            }
            return string;
        }

        private void markMatchingRegions(StyledString string, int index, int[] matchingRegions, StyledString.Styler styler) {
            if (matchingRegions != null) {
                int offset = -1;
                int length = 0;
                int i = 0;
                while (i + 1 < matchingRegions.length) {
                    if (offset == -1) {
                        offset = index + matchingRegions[i];
                    }
                    if (i + 2 < matchingRegions.length && matchingRegions[i] + matchingRegions[i + 1] == matchingRegions[i + 2]) {
                        length += matchingRegions[i + 1];
                    } else {
                        string.setStyle(offset, length + matchingRegions[i + 1], styler);
                        offset = -1;
                        length = 0;
                    }
                    i += 2;
                }
            }
        }

        private Font getBoldFont() {
            if (this.fBoldFont == null) {
                Font font = TypeSelectionDialog.this.getDialogArea().getFont();
                FontData[] data = font.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                this.fBoldFont = new Font(font.getDevice(), data);
            }
            return this.fBoldFont;
        }

        private StyledString.Styler createBoldStyler() {
            return new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = TypeItemLabelProvider.this.getBoldFont();
                }
            };
        }

        private StyledString.Styler createBoldQualifierStyler() {
            return new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    StyledString.QUALIFIER_STYLER.applyStyles(textStyle);
                    textStyle.font = TypeItemLabelProvider.this.getBoldFont();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeItemsComparator
    implements Comparator<IType> {
        private final Map<String, String> fLib2Name = new HashMap<String, String>();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeItemsComparator() {
            ArrayList<String> locations = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IVMInstallType installType, List<String> locations, List<String> labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return MessageFormat.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, name);
        }

        @Override
        public int compare(IType left, IType right) {
            int rightCategory;
            int result = this.compareName(left.getElementName(), right.getElementName());
            if (result != 0) {
                return result;
            }
            result = this.compareTypeContainerName(TypeNameMatchLabelProvider.getTypeContainerName(left), TypeNameMatchLabelProvider.getTypeContainerName(right));
            if (result != 0) {
                return result;
            }
            int leftCategory = this.getElementTypeCategory(left);
            if (leftCategory < (rightCategory = this.getElementTypeCategory(right))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            return this.compareContainerName(left, right);
        }

        private int compareName(String leftString, String rightString) {
            int result = leftString.compareToIgnoreCase(rightString);
            if (result != 0 || rightString.length() == 0) {
                return result;
            }
            if (TypeSelectionDialog.isLowerCase(leftString.charAt(0)) && !TypeSelectionDialog.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (TypeSelectionDialog.isLowerCase(rightString.charAt(0)) && !TypeSelectionDialog.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            return leftString.compareTo(rightString);
        }

        private int compareTypeContainerName(String leftString, String rightString) {
            int leftLength = leftString.length();
            int rightLength = rightString.length();
            if (leftLength == 0 && rightLength > 0) {
                return -1;
            }
            if (leftLength == 0 && rightLength == 0) {
                return 0;
            }
            if (leftLength > 0 && rightLength == 0) {
                return 1;
            }
            return this.compareName(leftString, rightString);
        }

        private int compareContainerName(IType leftType, IType rightType) {
            return this.getContainerName(leftType).compareTo(this.getContainerName(rightType));
        }

        private String getContainerName(IType type) {
            IPackageFragmentRoot root = TypeNameMatchLabelProvider.getPackageFragmentRoot(type);
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)root, (long)0x30000000000L, (StringBuffer)buf);
            return buf.toString();
        }

        private int getElementTypeCategory(IType type) {
            try {
                if (TypeNameMatchLabelProvider.getPackageFragmentRoot(type).getKind() == 1) {
                    return 0;
                }
            }
            catch (JavaModelException jme) {
                EGFCoreUIPlugin.getDefault().logError(jme);
            }
            return 1;
        }
    }

    private class TypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final int _MyFilterVersion;
        private final TypeInfoFilter _infoFilter;

        public TypeItemsFilter(ITypeInfoFilterExtension extension) {
            super((FilteredItemsSelectionDialog)TypeSelectionDialog.this, (SearchPattern)new TypeSearchPattern());
            this._MyFilterVersion = TypeSelectionDialog.this._filterVersion;
            this._infoFilter = new TypeInfoFilter(this.patternMatcher.getPattern(), extension);
        }

        public boolean matchItem(Object item) {
            IType type = (IType)item;
            return this._infoFilter.matchesHistoryElement(type);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public int getMyFilterVersion() {
            return this._MyFilterVersion;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!(filter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)filter;
            if (this._MyFilterVersion != typeItemsFilter.getMyFilterVersion()) {
                return false;
            }
            return typeItemsFilter._infoFilter.isSubFilter(this._infoFilter.getText());
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!(iFilter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)iFilter;
            if (!this.getPattern().equals(typeItemsFilter.getPattern())) {
                return false;
            }
            return this._MyFilterVersion == typeItemsFilter.getMyFilterVersion();
        }

        public boolean matchesRawNamePattern(Object item) {
            return this.matchesRawNamePattern((IType)item);
        }

        public String getNamePattern() {
            return this._infoFilter.getNamePattern();
        }

        public String getPackagePattern() {
            return this._infoFilter.getPackagePattern();
        }

        public int getPackageFlags() {
            return this._infoFilter.getPackageFlags();
        }

        public boolean matchesRawNamePattern(IType type) {
            return this._infoFilter.matchesRawNamePattern(type);
        }

        public boolean matchesFilterExtension(IType type) {
            return this._infoFilter.matchesFilterExtension(type);
        }

        public int getMatchRule() {
            return this._infoFilter.getSearchFlags();
        }

        public String getPattern() {
            return this._infoFilter.getText();
        }

        public boolean isCamelCasePattern() {
            return this._infoFilter.isCamelCasePattern();
        }
    }

    private static class TypeSearchPattern
    extends SearchPattern {
        private String fPattern;

        private TypeSearchPattern() {
        }

        public void setPattern(String stringPattern) {
            this.fPattern = stringPattern;
        }

        public String getPattern() {
            return this.fPattern;
        }
    }

    private class TypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

