/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.egf.pattern.PatternPreferences;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.execution.ConsoleReporter;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyContentProvider;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyHelper;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEngine
extends PatternEngine {
    public JavaEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        JavaAssemblyHelper helper = new JavaAssemblyHelper(pattern, new JavaAssemblyContentProvider(pattern));
        String templatecontent = helper.visit();
        if (this.getPattern().getSuperPattern() != null) {
            Document document = new Document(templatecontent);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(8);
            parser.setSource(document.get().toCharArray());
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            cu.recordModifications();
            if ((cu.getFlags() & 1) == 0) {
                TypeDeclaration type = (TypeDeclaration)cu.types().get(0);
                String parentClassName = JavaNatureHelper.getClassName(this.getPattern().getSuperPattern());
                AST ast = type.getAST();
                SimpleType newSimpleType = ast.newSimpleType(ast.newName(parentClassName));
                type.setSuperclassType((Type)newSimpleType);
            }
            TextEdit rewrite = cu.rewrite((IDocument)document, null);
            try {
                rewrite.apply((IDocument)document);
            }
            catch (BadLocationException e1) {
                throw new PatternException((Throwable)e1);
            }
            templatecontent = document.get();
        }
        try {
            IPlatformFcore platformFactoryComponent = PatternHelper.getPlatformFcore((PatternElement)pattern);
            if (platformFactoryComponent == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error4, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            IProject project = platformFactoryComponent.getPlatformBundle().getProject();
            if (project == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            String classname = JavaNatureHelper.getClassName(pattern);
            IPath outputPath = this.computeFilePath(classname);
            FileHelper.setContent((IFile)project.getFile(outputPath), (String)templatecontent);
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private IPath computeFilePath(String classname) {
        String[] names;
        if (classname == null || "".equals(classname)) {
            throw new IllegalArgumentException();
        }
        Path result = new Path(PatternPreferences.getGenerationFolderName());
        String[] stringArray = names = classname.split("\\.");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.append(name);
            ++n2;
        }
        result = result.addFileExtension("java");
        return result;
    }

    public void executeWithInjection(PatternContext context, Object ... parameters) throws PatternException {
        this.setupExecutionReporter((InternalPatternContext)context);
        this.doExecute(context, parameters);
    }

    public void execute(PatternContext context) throws PatternException {
        this.setupExecutionReporter((InternalPatternContext)context);
        this.doExecute(context, null);
    }

    private void doExecute(PatternContext context, Object[] executionParameters) throws PatternException {
        try {
            Class<?> templateClass = this.loadTemplateClass(context);
            Object template = templateClass.newInstance();
            Class[] parameterClasses = null;
            Object[] parameterValues = null;
            if (executionParameters == null) {
                parameterClasses = new Class[]{Object.class};
                parameterValues = new Object[]{context};
            } else {
                int size = executionParameters == null ? 1 : executionParameters.length + 1;
                parameterClasses = new Class[size];
                parameterValues = new Object[size];
                parameterClasses[0] = PatternContext.class;
                parameterValues[0] = context;
                int n = 0;
                while (n < executionParameters.length) {
                    parameterClasses[n + 1] = Object.class;
                    parameterValues[n + 1] = executionParameters[n];
                    ++n;
                }
            }
            Method method = templateClass.getMethod("generate", parameterClasses);
            method.invoke(template, parameterValues);
        }
        catch (InvocationTargetException e) {
            throw new PatternException(e.getCause());
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private void setupExecutionReporter(InternalPatternContext context) throws PatternException {
        if (context.hasReporter()) {
            return;
        }
        PatternExecutionReporter reporter = (PatternExecutionReporter)context.getValue("pattern.execution.reporter");
        if (reporter == null) {
            reporter = new ConsoleReporter();
        }
        context.setReporter(reporter);
    }

    private Class<?> loadTemplateClass(PatternContext context) throws PatternException, ClassNotFoundException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new PatternException(Messages.assembly_error9);
        }
        String templateClassName = JavaNatureHelper.getClassName(pattern);
        if (templateClassName == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        Class templateClass = ((InternalPatternContext)context).getBundle(this.getBundleId()).loadClass(templateClassName);
        return templateClass;
    }
}

