/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal.resource;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.fcore.IResourceFcoreDelta;
import org.eclipse.egf.core.fcore.IResourceFcoreListener;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.internal.resource.ResourceFcoreDelta;
import org.eclipse.egf.core.pde.l10n.EGFPDEMessages;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreResourceListener
implements IResourceChangeListener {
    public int _overridenEventType = -1;
    private List<IResourceFcoreListener> _listeners;

    public FcoreResourceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    private void fireResourceFcore(IResourceFcoreDelta delta) {
        if (this._listeners != null) {
            for (IResourceFcoreListener listener : this._listeners) {
                listener.fcoreChanged(delta);
            }
        }
    }

    public void addResourceFcoreListener(IResourceFcoreListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<IResourceFcoreListener>();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeResourceFcoreListener(IResourceFcoreListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resourceChanged(IResourceChangeEvent event) {
        int eventType = this._overridenEventType == -1 ? event.getType() : this._overridenEventType;
        try {
            switch (eventType) {
                case 1: {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class ResourceDeltaVisitor
                    implements IResourceDeltaVisitor {
                        protected List<IProject> _affectedProjects = new UniqueEList();
                        protected List<IPath> _newFcores = new UniqueEList();
                        protected List<IPath> _removedFcores = new UniqueEList();
                        protected Map<IPath, IPath> _movedFcores = new HashMap<IPath, IPath>();
                        protected ResourceFcoreDelta _deltaFcores = new ResourceFcoreDelta();

                        ResourceDeltaVisitor() {
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            try {
                                if (delta.getResource().getType() == 1 && "fcore".equals(delta.getResource().getFileExtension())) {
                                    URI uri = URIHelper.getPlatformURI((IResource)delta.getResource());
                                    String bundleId = BundleHelper.getBundleId((IResource)delta.getResource());
                                    if (uri != null && bundleId != null) {
                                        if (delta.getKind() == 4) {
                                            if (delta.getFlags() != 131072 && (delta.getFlags() & 0x100) != 0) {
                                                this._deltaFcores.addUpdatedFcore(uri);
                                            }
                                        } else if (delta.getKind() == 1) {
                                            if ((delta.getFlags() & 0x1000) == 0) {
                                                this._deltaFcores.addNewFcore(uri);
                                                this._newFcores.add(delta.getResource().getFullPath());
                                                this._affectedProjects.add(delta.getResource().getProject());
                                            }
                                        } else if (delta.getKind() == 2) {
                                            if ((delta.getFlags() & 0x2000) != 0) {
                                                this._deltaFcores.addMovedFcore(uri, URIHelper.getPlatformURI((IPath)delta.getMovedToPath()));
                                                this._movedFcores.put(delta.getResource().getFullPath(), delta.getMovedToPath());
                                            } else {
                                                this._deltaFcores.addRemovedFcore(uri);
                                                this._removedFcores.add(delta.getResource().getFullPath());
                                                this._affectedProjects.add(delta.getResource().getProject());
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Throwable t) {
                                EGFPDEPlugin.getDefault().logError(new String("FcoreResourceListener.resourceChanged(..) _ "), t);
                            }
                            return true;
                        }

                        public ResourceFcoreDelta getFcoresDelta() {
                            return this._deltaFcores;
                        }

                        public Map<IPath, IPath> getMovedFcores() {
                            return this._movedFcores;
                        }

                        public List<IPath> getRemovedFcores() {
                            return this._removedFcores;
                        }

                        public List<IPath> getNewFcores() {
                            return this._newFcores;
                        }

                        public List<IProject> getAffectedProjects() {
                            return this._affectedProjects;
                        }
                    }
                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                    if (!(visitor.getMovedFcores().isEmpty() && visitor.getRemovedFcores().isEmpty() && visitor.getNewFcores().isEmpty())) {
                        FcoreSynchJob job = new FcoreSynchJob(visitor.getAffectedProjects(), visitor.getMovedFcores(), visitor.getRemovedFcores(), visitor.getNewFcores());
                        job.setUser(true);
                        job.schedule();
                    }
                    if (visitor.getFcoresDelta().isEmpty()) return;
                    if (EGFPDEPlugin.getDefault().isDebugging()) {
                        this.trace(visitor.getFcoresDelta());
                    }
                    this.fireResourceFcore(visitor.getFcoresDelta());
                }
                default: {
                    return;
                }
            }
        }
        catch (CoreException ce) {
            EGFPDEPlugin.getDefault().logError(new String("FcoreResourceListener.resourceChanged(..) _"), ce);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this._listeners = null;
    }

    protected IRunnableWithProgress createFcoreOperation(IStatus[] errorStatus, List<IResource> removedFcores, List<IResource> newFcores) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            }
        };
    }

    private void trace(IResourceFcoreDelta delta) {
        if (delta.getNewFcores().size() > 0) {
            EGFPDEPlugin.getDefault().logInfo(NLS.bind((String)"FcoreResourceListener New {0} Fcore{1}.", (Object)delta.getNewFcores().size(), (Object)(delta.getNewFcores().size() < 2 ? "" : "s")));
            for (URI uri : delta.getNewFcores()) {
                EGFPDEPlugin.getDefault().logWarning(URI.decode((String)uri.toString()), 1);
            }
        }
        if (delta.getRemovedFcores().size() > 0) {
            EGFPDEPlugin.getDefault().logInfo(NLS.bind((String)"FcoreResourceListener Removed {0} Fcore{1}.", (Object)delta.getRemovedFcores().size(), (Object)(delta.getRemovedFcores().size() < 2 ? "" : "s")));
            for (URI uri : delta.getRemovedFcores()) {
                EGFPDEPlugin.getDefault().logWarning(URI.decode((String)uri.toString()), 1);
            }
        }
        if (delta.getUpdatedFcores().size() > 0) {
            EGFPDEPlugin.getDefault().logInfo(NLS.bind((String)"FcoreResourceListener Updated {0} Fcore{1}.", (Object)delta.getUpdatedFcores().size(), (Object)(delta.getUpdatedFcores().size() < 2 ? "" : "s")));
            for (URI uri : delta.getUpdatedFcores()) {
                EGFPDEPlugin.getDefault().logWarning(URI.decode((String)uri.toString()), 1);
            }
        }
        if (delta.getMovedFcores().size() > 0) {
            EGFPDEPlugin.getDefault().logInfo(NLS.bind((String)"FcoreResourceListener Moved {0} Fcore{1}.", (Object)delta.getMovedFcores().size(), (Object)(delta.getMovedFcores().size() < 2 ? "" : "s")));
            for (URI uri : delta.getMovedFcores().keySet()) {
                EGFPDEPlugin.getDefault().logWarning(URI.decode((String)uri.toString()), 1);
                EGFPDEPlugin.getDefault().logInfo("To: " + URI.decode((String)((URI)delta.getMovedFcores().get(uri)).toString()), 2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FcoreSynchJob
    extends WorkspaceJob {
        private Map<IPath, IPath> _movedFcores;
        private List<IPath> _newFcores;
        private List<IPath> _removedFcores;

        FcoreSynchJob(List<IProject> affectedProjects, Map<IPath, IPath> movedFcores, List<IPath> removedFcores, List<IPath> newFcores) {
            super(EGFPDEMessages.PluginModelUpdate_progressMessage);
            this._movedFcores = movedFcores;
            this._removedFcores = removedFcores;
            this._newFcores = newFcores;
            this.setRule(this.getRule(affectedProjects));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                try {
                    IPluginChangesCommand unsetCommand;
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFPDEMessages.PluginModelUpdate_progressMessage, (int)((this._movedFcores.size() + this._removedFcores.size() + this._newFcores.size()) * 1000));
                    for (IPath path : this._movedFcores.keySet()) {
                        if (BundleHelper.getPluginModelBase((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))) == null) continue;
                        unsetCommand = EGFPDEPlugin.getFcoreExtensionHelper().unsetFcoreExtension(path);
                        unsetCommand.execute((IProgressMonitor)subMonitor.newChild(1000, 0));
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (BundleHelper.getPluginModelBase((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this._movedFcores.get(path).segment(0))) == null) continue;
                        IPluginChangesCommand createCommand = EGFPDEPlugin.getFcoreExtensionHelper().setFcoreExtension(this._movedFcores.get(path));
                        createCommand.execute((IProgressMonitor)subMonitor.newChild(1000, 0));
                        if (!monitor.isCanceled()) continue;
                        throw new InterruptedException();
                    }
                    for (IPath path : this._removedFcores) {
                        if (BundleHelper.getPluginModelBase((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))) == null) continue;
                        unsetCommand = EGFPDEPlugin.getFcoreExtensionHelper().unsetFcoreExtension(path);
                        unsetCommand.execute((IProgressMonitor)subMonitor.newChild(1000, 0));
                        if (!monitor.isCanceled()) continue;
                        throw new InterruptedException();
                    }
                    for (IPath path : this._newFcores) {
                        if (BundleHelper.getPluginModelBase((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))) == null) continue;
                        IPluginChangesCommand createCommand = EGFPDEPlugin.getFcoreExtensionHelper().setFcoreExtension(path);
                        createCommand.execute((IProgressMonitor)subMonitor.newChild(1000, 0));
                        if (!monitor.isCanceled()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private ISchedulingRule getRule(List<IProject> affectedProjects) {
            ISchedulingRule result = null;
            if (!affectedProjects.isEmpty()) {
                IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
                for (IResource iResource : affectedProjects) {
                    result = MultiRule.combine(result, (ISchedulingRule)factory.modifyRule(iResource));
                }
            }
            return result;
        }
    }
}

