/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.core.platform.internal.pde.PlatformManager;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformExtensionPointDelta
implements IPlatformExtensionPointDelta {
    private Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> _added = new HashMap<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>>();
    private Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> _removed = new HashMap<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>>();

    @Override
    public IPlatformExtensionPoint[] getAddedPlatformExtensionPoints() {
        ArrayList extensionPoints = new ArrayList();
        for (Class<? extends IPlatformExtensionPoint> clazz : this._added.keySet()) {
            extensionPoints.addAll(this._added.get(clazz));
        }
        return extensionPoints.toArray(new IPlatformExtensionPoint[extensionPoints.size()]);
    }

    @Override
    public <T extends IPlatformExtensionPoint> T[] getAddedPlatformExtensionPoints(Class<T> clazz) {
        ArrayList<Object> extensionPoints = new ArrayList<Object>();
        if (clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz) && this._added.get(clazz) != null) {
            extensionPoints.addAll((Collection<Object>)this._added.get(clazz));
        }
        return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
    }

    @Override
    public IPlatformExtensionPoint[] getRemovedPlatformExtensionPoints() {
        ArrayList extensionPoints = new ArrayList();
        for (Class<? extends IPlatformExtensionPoint> clazz : this._removed.keySet()) {
            extensionPoints.addAll(this._removed.get(clazz));
        }
        return extensionPoints.toArray(new IPlatformExtensionPoint[extensionPoints.size()]);
    }

    @Override
    public <T extends IPlatformExtensionPoint> T[] getRemovedPlatformExtensionPoints(Class<T> clazz) {
        ArrayList<Object> extensionPoints = new ArrayList<Object>();
        if (clazz != null && PlatformManager.getExtensionPointsValues().contains(clazz) && this._removed.get(clazz) != null) {
            extensionPoints.addAll((Collection<Object>)this._removed.get(clazz));
        }
        return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
    }

    protected boolean isEmpty() {
        return this._added.size() == 0 && this._removed.size() == 0;
    }

    protected boolean storeAddedPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !PlatformManager.getExtensionPointsValues().contains(clazz) || extensionPoint == null) {
            return false;
        }
        List<IPlatformExtensionPoint> extensionPoints = this._added.get(clazz);
        if (extensionPoints == null) {
            extensionPoints = new ArrayList<IPlatformExtensionPoint>();
            this._added.put(clazz, extensionPoints);
        }
        return extensionPoints.add(extensionPoint);
    }

    protected boolean storeRemovedPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !PlatformManager.getExtensionPointsValues().contains(clazz) || extensionPoint == null) {
            return false;
        }
        List<IPlatformExtensionPoint> extensionPoints = this._removed.get(clazz);
        if (extensionPoints == null) {
            extensionPoints = new ArrayList<IPlatformExtensionPoint>();
            this._removed.put(clazz, extensionPoints);
        }
        return extensionPoints.add(extensionPoint);
    }
}

