/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.EGFResourceLoadedListener;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.pages.ImplementationPage;
import org.eclipse.egf.pattern.ui.editors.pages.OverviewPage;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.pages.SpecificationPage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;

public class PatternEditor
extends FormEditor
implements EGFResourceLoadedListener.ResourceUser,
IEditingDomainProvider {
    private String initialPatternName;
    protected ObjectUndoContext undoContext;
    private TransactionalEditingDomain editingDomain;
    protected boolean userHasSavedResource;
    protected boolean resourceHasBeenExternallyChanged;
    protected boolean resourceHasBeenRemoved;
    private final EGFResourceLoadedListener.ResourceListener resourceListener = new EGFResourceLoadedListener.ResourceListener(){

        public void resourceMoved(Resource movedResource, URI oldURI) {
            if (movedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = false;
                PatternEditor.this.resourceHasBeenRemoved = false;
                PatternEditor.this.userHasSavedResource = false;
                for (PatternEditorPage page : PatternEditor.this.pages) {
                    page.rebind();
                }
                PatternEditor.this.addPatternChangeAdapter();
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternEditor.this.getOperationHistory().dispose((IUndoContext)(this).PatternEditor.this.undoContext, true, true, true);
                        PatternEditor.this.firePropertyChange(257);
                    }
                });
            }
        }

        public void resourceDeleted(Resource deletedResource) {
            if (deletedResource == PatternEditor.this.getResource()) {
                if (!PatternEditor.this.isDirty()) {
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternEditor.this, false);
                        }
                    });
                } else {
                    PatternEditor.this.resourceHasBeenRemoved = true;
                }
            }
        }

        public void resourceReloaded(Resource reloadedResource) {
            if (reloadedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = false;
                PatternEditor.this.resourceHasBeenRemoved = false;
                PatternEditor.this.userHasSavedResource = false;
                for (PatternEditorPage page : PatternEditor.this.pages) {
                    page.rebind();
                }
                PatternEditor.this.addPatternChangeAdapter();
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternEditor.this.getOperationHistory().dispose((IUndoContext)(this).PatternEditor.this.undoContext, true, true, true);
                        PatternEditor.this.firePropertyChange(257);
                    }
                });
            }
        }

        public void externalUpdate(Resource changedResource) {
            if (changedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = true;
            }
        }

        public void internalUpdate(Resource changedResource) {
            if (changedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = false;
                PatternEditor.this.resourceHasBeenRemoved = false;
                PatternEditor.this.userHasSavedResource = false;
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternEditor.this.firePropertyChange(257);
                        String name = PatternEditor.this.getPattern().getName();
                        if (PatternEditor.this.initialPatternName != null && !PatternEditor.this.initialPatternName.equals(name)) {
                            try {
                                ExtensionHelper.getExtension((PatternNature)PatternEditor.this.getPattern().getNature()).getRefactoringManager().renamePattern(PatternEditor.this.getPattern(), PatternEditor.this.initialPatternName, name);
                            }
                            catch (Exception e) {
                                Activator.getDefault().logError(e);
                            }
                            PatternEditor.this.initialPatternName = name;
                        }
                    }
                });
            }
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p == PatternEditor.this) {
                PatternEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private final List<PatternEditorPage> pages = new ArrayList<PatternEditorPage>();
    protected EContentAdapter editorResourceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 1: {
                        PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                PatternEditor.this.firePropertyChange(257);
                            }
                        });
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource innerTarget) {
            this.basicSetTarget((Notifier)innerTarget);
        }

        protected void unsetTarget(Resource innerTarget) {
            this.basicUnsetTarget((Notifier)innerTarget);
        }
    };
    AdapterImpl refresher = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME.equals(msg.getFeature())) {
                PatternEditor.this.setPartName((String)msg.getNewValue());
            }
        }
    };
    private final IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
            switch (event.getEventType()) {
                case 4: {
                    if (!affectedResources.contains(PatternEditor.this.getResource())) break;
                    IUndoableOperation operation = event.getOperation();
                    operation.removeContext(((IWorkspaceCommandStack)PatternEditor.this.getEditingDomain().getCommandStack()).getDefaultUndoContext());
                    operation.addContext((IUndoContext)PatternEditor.this.undoContext);
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.firePropertyChange(257);
                        }
                    });
                    break;
                }
                case 9: 
                case 10: {
                    if (!affectedResources.contains(PatternEditor.this.getResource())) break;
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.firePropertyChange(257);
                        }
                    });
                }
            }
        }
    };

    public PatternEditor() {
        this.initializeEditingDomain();
    }

    public boolean userHasSavedResource() {
        return this.userHasSavedResource;
    }

    public boolean resourceHasBeenExternallyChanged() {
        return this.resourceHasBeenExternallyChanged;
    }

    protected void handleActivate() {
        if (this.resourceHasBeenRemoved) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            }
        } else if (this.resourceHasBeenExternallyChanged) {
            this.handleChangedResource();
        }
    }

    protected void handleChangedResource() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            EGFResourceLoadedListener.RESOURCE_MANAGER.reloadResource(this.getResource());
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    PatternEditor.this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            try {
                                Resource resourceToSave = PatternEditor.this.getResource();
                                long timeStamp = resourceToSave.getTimeStamp();
                                resourceToSave.save(Collections.EMPTY_MAP);
                                if (resourceToSave.getTimeStamp() != timeStamp) {
                                    (this).PatternEditor.this.userHasSavedResource = true;
                                }
                            }
                            catch (IOException ioe) {
                                ThrowableHandler.handleThrowable((String)Activator.getDefault().getPluginID(), (Throwable)ioe);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    ThrowableHandler.handleThrowable((String)Activator.getDefault().getPluginID(), (Throwable)t);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            this.firePropertyChange(257);
        }
        catch (Throwable t) {
            ThrowableHandler.handleThrowable((String)Activator.getDefault().getPluginID(), (Throwable)t);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public ObjectUndoContext getUndoContext() {
        return this.undoContext;
    }

    private void addPatternChangeAdapter() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Pattern pattern = PatternEditor.this.getPattern();
                if (pattern != null) {
                    pattern.eAdapters().add((Object)PatternEditor.this.refresher);
                    PatternEditor.this.setPartName(pattern.getName());
                }
            }
        });
    }

    private void removePatternChangeAdapter() {
        Pattern pattern = this.getPattern();
        if (pattern != null && pattern.eAdapters().contains((Object)this.refresher)) {
            pattern.eAdapters().remove((Object)this.refresher);
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        return super.getAdapter(key);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        if (this.getResource() == null) {
            return false;
        }
        return this.getResource().isModified();
    }

    protected void addPages() {
        try {
            this.addPage(new OverviewPage(this));
            this.addPage(new SpecificationPage(this));
            this.addPage(new ImplementationPage(this));
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
        }
    }

    private Pattern getPattern() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getPattern();
    }

    public Resource getResource() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getResource();
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof PatternEditorInput)) {
            throw new PartInitException(Messages.Editor_wrong_input);
        }
        super.init(site, editorInput);
        this.initialPatternName = this.getPattern().getName();
        site.getPage().addPartListener(this.partListener);
        this.resourceHasBeenExternallyChanged = EGFResourceLoadedListener.RESOURCE_MANAGER.resourceHasBeenExternallyChanged(this.getResource());
        EGFResourceLoadedListener.RESOURCE_MANAGER.addObserver((EGFResourceLoadedListener.ResourceUser)this);
        EGFResourceLoadedListener.RESOURCE_MANAGER.populateUndoContext(this.getOperationHistory(), this.undoContext, this.getResource());
        this.addPatternChangeAdapter();
    }

    protected void initializeEditingDomain() {
        this.editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        this.undoContext = new ObjectUndoContext((Object)this, "undoContext label");
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.editorResourceAdapter);
    }

    public void dispose() {
        if (this.getEditorInput() != null && this.getEditorInput() instanceof PatternEditorInput) {
            EGFResourceLoadedListener.RESOURCE_MANAGER.removeObserver((EGFResourceLoadedListener.ResourceUser)this);
            this.getSite().getPage().removePartListener(this.partListener);
            this.removePatternChangeAdapter();
        }
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.getOperationHistory().dispose((IUndoContext)this.undoContext, true, true, true);
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.editorResourceAdapter);
        super.dispose();
    }

    public void addPage(PatternEditorPage page) throws PartInitException {
        this.pages.add(page);
        this.addPage((IFormPage)page);
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Conflict", (String)"External changes, close the editor ?");
    }

    public EGFResourceLoadedListener.ResourceListener getListener() {
        return this.resourceListener;
    }

    public static void openEditor(IWorkbenchPage page, Pattern pattern) {
        if (page == null || pattern == null) {
            throw new IllegalArgumentException();
        }
        Resource resource = pattern.eResource();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new PatternEditorInput(resource, pattern.getID()), (String)"org.eclipse.egf.pattern.ui.editors.PatternEditor");
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
        }
    }
}

