/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrchestrationProductionContext<P extends Orchestration>
extends ProductionContext<P, OrchestrationParameter> {
    public OrchestrationProductionContext(ProjectBundleSession projectBundleSession, P element, String name) {
        super(projectBundleSession, element, name);
    }

    public OrchestrationProductionContext(IProductionContext<FactoryComponent, Contract> parent, ProjectBundleSession projectBundleSession, P element, String name) {
        super(parent, projectBundleSession, element, name);
    }

    public boolean isSetAtRuntime(Object key) throws InvocationException {
        this.getOrchestrationParameter(key, this.getInputValueKeys());
        InvocationContract invocationContract = (InvocationContract)key;
        if (invocationContract.getFactoryComponentContract() != null && this.getParent() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
            return this.getParent().isSetAtRuntime((Object)invocationContract);
        }
        return false;
    }

    public Class<?> getInputValueType(Object key) throws InvocationException {
        OrchestrationParameter orchestrationParameter = this.getOrchestrationParameter(key, this.getInputValueKeys());
        InvocationContract invocationContract = (InvocationContract)key;
        Class valueType = null;
        if (invocationContract.getFactoryComponentContract() != null) {
            if (this.getParent() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
                valueType = this.getParent().getInputValueType((Object)invocationContract);
            }
        } else {
            if (orchestrationParameter == null) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
            }
            ProductionContext.Data data = (ProductionContext.Data)this._inputDatas.get(orchestrationParameter);
            if (data != null) {
                valueType = data.getType();
            }
        }
        return valueType;
    }

    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        OrchestrationParameter orchestrationParameter = this.getOrchestrationParameter(key, this.getInputValueKeys());
        InvocationContract invocationContract = (InvocationContract)key;
        Object value = null;
        if (invocationContract.getFactoryComponentContract() != null) {
            if (this.getParent() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
                value = this.getParent().getInputValue((Object)invocationContract, clazz);
            }
        } else {
            if (orchestrationParameter == null) {
                throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
            }
            ProductionContext.Data inputData = (ProductionContext.Data)this._inputDatas.get(orchestrationParameter);
            if (inputData != null) {
                value = this.getValue(orchestrationParameter, clazz, inputData);
            }
        }
        return (R)value;
    }

    public Class<?> getOutputValueType(Object key) throws InvocationException {
        this.getOrchestrationParameter(key, this.getOutputValueKeys());
        InvocationContract invocationContract = (InvocationContract)key;
        Class valueType = null;
        if (invocationContract.getFactoryComponentContract() != null && this.getParent() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.IN) {
            valueType = this.getParent().getOutputValueType((Object)invocationContract);
        }
        return valueType;
    }

    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        this.getOrchestrationParameter(key, this.getOutputValueKeys());
        InvocationContract invocationContract = (InvocationContract)key;
        Object value = null;
        if (invocationContract.getFactoryComponentContract() != null && this.getParent() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.IN) {
            value = this.getParent().getOutputValue((Object)invocationContract, clazz);
        }
        return (R)value;
    }

    public void setOutputValue(Object key, Object value) throws InvocationException {
        this.getOrchestrationParameter(key, this.getOutputValueKeys());
        InvocationContract invocationContract = (InvocationContract)key;
        if (invocationContract.getFactoryComponentContract() != null && this.getParent() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.IN) {
            this.getParent().setOutputValue((Object)invocationContract, value);
        }
    }

    private OrchestrationParameter getOrchestrationParameter(Object key, Collection<OrchestrationParameter> keys) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
        }
        if (!(key instanceof InvocationContract)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{InvocationContract.class.getName(), EMFHelper.getText((Object)key), key.getClass().getName(), this.getName()}));
        }
        OrchestrationParameter orchestrationParameter = null;
        for (OrchestrationParameter innerOrchestrationParameter : keys) {
            if (!innerOrchestrationParameter.getInvocationContracts().contains(key)) continue;
            orchestrationParameter = innerOrchestrationParameter;
            break;
        }
        return orchestrationParameter;
    }
}

