/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.common.java.AbstractJavaAssemblyContentProvider;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;

public class JavaAssemblyContentProvider
extends AbstractJavaAssemblyContentProvider {
    public JavaAssemblyContentProvider(Pattern pattern) {
        super(pattern, new JavaMethodGenerationHelper("out"));
    }

    protected void call(MethodCall object) throws PatternException {
        this.javaMethodHelper.addCallStatement(object.getCalled());
        this.content.append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(PatternInjectedCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        String className = JavaNatureHelper.getClassName(pattern);
        if (className == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        super.call(call);
    }

    protected void addMethodBodies() throws PatternException {
        for (PatternMethod method : PatternHelper.getUserMethods((Pattern)this.pattern)) {
            this.javaMethodHelper.addSignature(method);
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append(this.getMethodContent(method)).append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }
}

