/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.ecore.EPackageHelper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

public class ParameterTypeHelper {
    public static final ParameterTypeHelper INSTANCE = new ParameterTypeHelper();

    public String getTypeLiteral(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index == -1) {
            return type;
        }
        EPackage ePackage = this.getEPackage(type, index);
        ePackage.getNsURI();
        String basePackage = EPackageHelper.getBasePackage(ePackage);
        if (basePackage == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.assembly_error7, (Object)type));
        }
        if ("".equals(basePackage)) {
            return String.valueOf(ePackage.getName()) + "." + this.getClassName(type, index);
        }
        return String.valueOf(basePackage) + "." + this.getClassName(type, index);
    }

    public Object loadClass(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index > 0) {
            return this.loadEClass(type, index);
        }
        try {
            return this.getClass().getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private EClass loadEClass(String type, int index) {
        String nsuri = this.getNsURI(type, index);
        String className = this.getClassName(type, index);
        EPackage ePackage = this.getEPackage(type, index);
        EClass eClassifier = (EClass)ePackage.getEClassifier(className);
        if (eClassifier == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.classloader_error3, (Object)className, (Object)nsuri));
        }
        return eClassifier;
    }

    private EPackage getEPackage(String type, int index) {
        return EPackageHelper.REGISTRY.getEPackage(this.getNsURI(type, index));
    }

    private String getNsURI(String type, int index) {
        return type.substring(0, index);
    }

    private String getClassName(String type, int index) {
        String className = type.substring(index + 1);
        if (className.startsWith("//")) {
            return className.substring(2);
        }
        return className;
    }

    private ParameterTypeHelper() {
    }
}

