/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.EGFValidator;
import org.eclipse.egf.model.editor.dialogs.ActivitySelectionDialog;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.ui.EGFProducerUIPlugin;
import org.eclipse.egf.producer.ui.internal.dialogs.ActivityValidationSelectionDialog;
import org.eclipse.egf.producer.ui.internal.ui.ProducerUIImages;
import org.eclipse.egf.producer.ui.l10n.ProducerUIMessages;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalRunActivityAction
extends Action
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private List<Activity> _validates = null;

    public GlobalRunActivityAction() {
        this.setText(ProducerUIMessages.GlobalRunActivityAction_label);
        this.setDescription(ProducerUIMessages.GlobalRunActivityAction_description);
        this.setToolTipText(ProducerUIMessages.GlobalRunActivityAction_tooltip);
        this.setImageDescriptor(ProducerUIImages.EGF_RUN_ACTIVITY);
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        this._validates = null;
        ActivitySelectionDialog activityDialog = new ActivitySelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), false);
        activityDialog.setTitle(ProducerUIMessages.GlobalRunActivityAction_dialogTitle);
        int result = activityDialog.open();
        if (result != 0) {
            return;
        }
        Object[] selection = activityDialog.getResult();
        if (selection == null || selection.length != 1) {
            return;
        }
        final Activity[] activity = new Activity[]{(Activity)selection[0]};
        Throwable throwable = null;
        final IActivityManager[] activityManager = new IActivityManager[1];
        final int[] ticks = new int[1];
        try {
            ActivityManagerProducer producer = null;
            try {
                producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity[0]);
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
            activityManager[0] = producer.createActivityManager(activity[0]);
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                EGFValidator validator;
                Diagnostic validationDiag;
                IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
                String validate = store.getString("org.eclipse.egf.core.validate.model.instances.before.launch");
                List activities = activityManager[0].getActivities();
                int status = this.showValidateDialog(activities, !validate.equals("never"), validate.equals("prompt"));
                if (status != 0) {
                    return;
                }
                if (this._validates != null && this._validates.size() != 0 && (validationDiag = (validator = new EGFValidator(this._validates)).validate()).getSeverity() == 4) {
                    return;
                }
            }
            catch (InvocationException ie) {
                throwable = ie;
            }
        }
        if (throwable == null) {
            try {
                activityManager[0].initializeContext();
                final Diagnostic preInvokeDiag = activityManager[0].canInvoke();
                if (preInvokeDiag.getSeverity() != 0) {
                    if (EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                        EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                            public void run() {
                                EGFValidator.handleDiagnostic((String)ProducerUIMessages.ActivityValidationSelectionDialog_Title, (String)ProducerUIMessages._UI_PreInvokeProblems_message, (Diagnostic)preInvokeDiag);
                            }
                        });
                    }
                    if (preInvokeDiag.getSeverity() == 4) {
                        return;
                    }
                }
            }
            catch (InvocationException ie) {
                throwable = ie;
            }
        }
        if (throwable == null) {
            try {
                ticks[0] = activityManager[0].getSteps();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (throwable == null) {
            WorkspaceJob activityJob = new WorkspaceJob(ProducerUIMessages.GlobalRunActivityAction_label){

                public boolean belongsTo(Object family) {
                    return EGFCorePlugin.FAMILY_MANUAL_BUILD.equals(family);
                }

                public IStatus runInWorkspace(IProgressMonitor innerMonitor) throws CoreException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)innerMonitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)EMFHelper.getText((Object)activityManager[0].getElement())), (int)(1000 * ticks[0]));
                    try {
                        try {
                            try {
                                if (EGFProducerUIPlugin.getDefault().isDebugging()) {
                                    if (ticks[0] == 1) {
                                        EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocation, (Object)EMFHelper.getText((Object)activity[0])));
                                    } else {
                                        EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocations, (Object)EMFHelper.getText((Object)activity[0]), (Object)ticks[0]));
                                    }
                                }
                                final Diagnostic diagnostic = activityManager[0].invoke((IProgressMonitor)subMonitor.newChild(1000 * ticks[0], 0));
                                if (subMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                if (diagnostic != null && diagnostic.getSeverity() != 0 && EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                                    EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            EGFValidator.handleDiagnostic((String)ProducerUIMessages.ActivityValidationSelectionDialog_Title, (String)ProducerUIMessages._UI_PostInvokeProblems_message, (Diagnostic)diagnostic);
                                        }
                                    });
                                }
                            }
                            catch (InvocationException ie) {
                                if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                                    throw (CoreException)ie.getCause();
                                }
                                ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie);
                                try {
                                    activityManager[0].dispose();
                                }
                                catch (InvocationException ie2) {
                                    if (ie2.getCause() != null && ie2.getCause() instanceof CoreException) {
                                        throw (CoreException)ie2.getCause();
                                    }
                                    ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie2);
                                }
                                catch (Throwable t) {
                                    throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                                }
                            }
                            catch (Throwable t) {
                                throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                            }
                        }
                        finally {
                            try {
                                activityManager[0].dispose();
                            }
                            catch (InvocationException ie) {
                                if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                                    throw (CoreException)ie.getCause();
                                }
                                ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie);
                            }
                            catch (Throwable t) {
                                throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                            }
                        }
                    }
                    finally {
                        innerMonitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            activityJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            activityJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ProducerUIImages.EGF_RUN_ACTIVITY);
            activityJob.setPriority(30);
            activityJob.setUser(true);
            activityJob.setSystem(false);
            activityJob.schedule();
        }
        if (throwable != null && !(throwable instanceof InterruptedException)) {
            ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)throwable);
        }
    }

    private int showValidateDialog(List<Activity> activities, boolean validate, boolean prompt) {
        if (validate) {
            if (prompt && activities != null && activities.size() > 0) {
                ActivityValidationSelectionDialog dialog = new ActivityValidationSelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), activities);
                if (dialog.open() == 1) {
                    return 1;
                }
                Object[] objects = dialog.getResult();
                this._validates = new ArrayList<Activity>(objects.length);
                int i = 0;
                while (i < objects.length) {
                    this._validates.add((Activity)objects[i]);
                    ++i;
                }
            } else {
                this._validates = activities;
            }
        }
        return 0;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    public void init(IAction action) {
    }
}

