/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.ContractContainer;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FactoryComponentContract;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.InvocationContractContainer;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.egf.model.fcore.OrchestrationParameterContainer;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.helper.ActivityCycleFinder;
import org.eclipse.egf.model.types.Type;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreValidator
extends EObjectValidator {
    public static final FcoreValidator INSTANCE = new FcoreValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.fcore";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    public FcoreValidator() {
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return FcorePackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateModelElement((ModelElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateNamedModelElement((NamedModelElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateActivity((Activity)value, diagnostics, context);
            }
            case 3: {
                return this.validateContract((Contract)value, diagnostics, context);
            }
            case 4: {
                return this.validateFactoryComponent((FactoryComponent)value, diagnostics, context);
            }
            case 5: {
                return this.validateContractContainer((ContractContainer)value, diagnostics, context);
            }
            case 6: {
                return this.validateFactoryComponentContract((FactoryComponentContract)value, diagnostics, context);
            }
            case 7: {
                return this.validateViewpointContainer((ViewpointContainer)value, diagnostics, context);
            }
            case 8: {
                return this.validateViewpoint((Viewpoint)value, diagnostics, context);
            }
            case 9: {
                return this.validateOrchestration((Orchestration)value, diagnostics, context);
            }
            case 10: {
                return this.validateOrchestrationParameterContainer((OrchestrationParameterContainer)value, diagnostics, context);
            }
            case 11: {
                return this.validateOrchestrationParameter((OrchestrationParameter)value, diagnostics, context);
            }
            case 12: {
                return this.validateInvocation((Invocation)value, diagnostics, context);
            }
            case 13: {
                return this.validateInvocationContractContainer((InvocationContractContainer)value, diagnostics, context);
            }
            case 14: {
                return this.validateInvocationContract((InvocationContract)value, diagnostics, context);
            }
            case 15: {
                return this.validateContractMode((ContractMode)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateModelElement(ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(modelElement, diagnostics, context);
    }

    public boolean validateNamedModelElement(NamedModelElement namedModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedModelElement, diagnostics, context);
    }

    public boolean validateActivity(Activity activity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(activity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivity_MandatoryName(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivity_ActivityCycle(activity, diagnostics, context);
        }
        return result;
    }

    public boolean validateActivity_MandatoryName(Activity activity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (activity.getName() == null || activity.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryName", FcoreValidator.getObjectLabel((EObject)activity, context), "The attribute name is mandatory"}, new Object[]{activity}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateActivity_ActivityCycle(Activity activity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ActivityCycleFinder finder = new ActivityCycleFinder(activity);
        ModelElement element = finder.getFirstRepetition();
        if (element != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ActivityCycle", FcoreValidator.getObjectLabel((EObject)element, context)}, new Object[]{element}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateContract(Contract contract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(contract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateContract_UniqueName(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateContract_UselessMandatoryMode(contract, diagnostics, context);
        }
        return result;
    }

    public boolean validateFactoryComponent(FactoryComponent factoryComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factoryComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivity_MandatoryName(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivity_ActivityCycle(factoryComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validateContractContainer(ContractContainer contractContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(contractContainer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contractContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contractContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contractContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contractContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contractContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contractContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateContractContainer_FactoryComponentContract(contractContainer, diagnostics, context);
        }
        return result;
    }

    public boolean validateContractContainer_FactoryComponentContract(ContractContainer contractContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (contractContainer.getActivity() == null || !(contractContainer.getActivity() instanceof FactoryComponent)) {
            return true;
        }
        boolean mismatch = false;
        for (Contract contract : contractContainer.getContracts()) {
            if (contract instanceof FactoryComponentContract) continue;
            mismatch = true;
            break;
        }
        if (mismatch) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"FactoryComponentContract", FcoreValidator.getObjectLabel((EObject)contractContainer, context), "This ContractContainer should only hold FactoryComponentContract"}, new Object[]{contractContainer}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateFactoryComponentContract(FactoryComponentContract factoryComponentContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factoryComponentContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateContract_UniqueName(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateContract_UselessMandatoryMode(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFactoryComponentContract_UselessFactoryComponentContract(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFactoryComponentContract_OutModeIsRestricted(factoryComponentContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateFactoryComponentContract_UselessFactoryComponentContract(FactoryComponentContract factoryComponentContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (factoryComponentContract.getInvocationContracts() == null || factoryComponentContract.getInvocationContracts().size() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UselessFactoryComponentContract", FcoreValidator.getObjectLabel((EObject)factoryComponentContract, context), "This FactoryComponentContract is not used"}, new Object[]{factoryComponentContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateViewpointContainer(ViewpointContainer viewpointContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewpointContainer, diagnostics, context);
    }

    public boolean validateViewpoint(Viewpoint viewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewpoint, diagnostics, context);
    }

    public boolean validateOrchestration(Orchestration orchestration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(orchestration, diagnostics, context);
    }

    public boolean validateOrchestrationParameterContainer(OrchestrationParameterContainer orchestrationParameterContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(orchestrationParameterContainer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(orchestrationParameterContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(orchestrationParameterContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(orchestrationParameterContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(orchestrationParameterContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(orchestrationParameterContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(orchestrationParameterContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOrchestrationParameterContainer_UselessOrchestrationParameterContainer(orchestrationParameterContainer, diagnostics, context);
        }
        return result;
    }

    public boolean validateOrchestrationParameter(OrchestrationParameter orchestrationParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(orchestrationParameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(orchestrationParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(orchestrationParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(orchestrationParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(orchestrationParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(orchestrationParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(orchestrationParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOrchestrationParameter_UselessOrchestrationParameter(orchestrationParameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateOrchestrationParameter_UselessOrchestrationParameter(OrchestrationParameter orchestrationParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (orchestrationParameter.getInvocationContracts() == null || orchestrationParameter.getInvocationContracts().size() < 2) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UselessOrchestrationParameter", FcoreValidator.getObjectLabel((EObject)orchestrationParameter, context), "This OrchestrationParameter should be defined in an InvocationContract"}, new Object[]{orchestrationParameter}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateOrchestrationParameterContainer_UselessOrchestrationParameterContainer(OrchestrationParameterContainer orchestrationParameterContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (orchestrationParameterContainer.getOrchestrationParameters() == null || orchestrationParameterContainer.getOrchestrationParameters().size() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UselessOrchestrationParameterContainer", FcoreValidator.getObjectLabel((EObject)orchestrationParameterContainer, context), "It should contain at least one InvocationParameter to be useful"}, new Object[]{orchestrationParameterContainer}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocation(Invocation invocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(invocation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(invocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(invocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(invocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(invocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(invocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(invocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocation_MandatoryInvokedContract(invocation, diagnostics, context);
        }
        return result;
    }

    public boolean validateInvocation_MandatoryInvokedContract(Invocation invocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocation.getInvokedActivity() == null || invocation.getInvokedActivity().getContracts() == null || invocation.getInvokedActivity().getContracts().size() == 0) {
            return true;
        }
        for (Contract contract : invocation.getInvokedActivity().getContracts()) {
            if (!contract.isMandatory() || contract.getType() == null || contract.getType().getValue() != null) continue;
            boolean found = false;
            if (invocation.getInvocationContracts() != null) {
                for (InvocationContract invocationContract : invocation.getInvocationContracts()) {
                    if (!contract.equals(invocationContract.getInvokedContract())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryInvokedContract", FcoreValidator.getObjectLabel((EObject)invocation, context), NLS.bind((String)"Mandatory Contract ''{0}'' should be invoked", (Object)FcoreValidator.getObjectLabel((EObject)contract, context))}, new Object[]{invocation}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContractContainer(InvocationContractContainer invocationContractContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invocationContractContainer, diagnostics, context);
    }

    public boolean validateInvocationContract(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(invocationContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidInvokedContract(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidInvokedContractType(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidFactoryComponentContract(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidFactoryComponentContractType(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidOrchestrationParameter(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidOrchestrationParameterType(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidSourceInvocationContract(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_ValidSourceInvocationContractType(invocationContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContract_UselessTypeValue(invocationContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateInvocationContract_ValidInvokedContract(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getInvokedContract() == null || invocationContract.getInvocation() == null || invocationContract.getInvocation().getInvokedActivity() == null) {
            return true;
        }
        boolean found = false;
        for (Contract contract : invocationContract.getInvocation().getInvokedActivity().getContracts()) {
            if (contract != invocationContract.getInvokedContract()) continue;
            found = true;
            break;
        }
        if (!found) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ValidInvokedContract", FcoreValidator.getObjectLabel((EObject)invocationContract, context)}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidInvokedContractType(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getInvokedContract() == null || invocationContract.getInvokedContract().getType() == null || invocationContract.getType() == null) {
            return true;
        }
        if (!ClassHelper.asSubClass(invocationContract.getInvokedContract().getType().getType(), invocationContract.getType().getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidInvokedContractType", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract Type and Contract Type mismatch"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidFactoryComponentContract(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getFactoryComponentContract() == null || invocationContract.getInvokedMode() == null) {
            return true;
        }
        if (invocationContract.getInvokedMode() == ContractMode.OUT) {
            if (invocationContract.getFactoryComponentContract().getMode() == ContractMode.IN) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidFactoryComponentContract", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract in Out Mode couldn't be assigned to a FactoryComponentContract in In Mode"}, new Object[]{invocationContract}, context));
                }
                return false;
            }
        } else if (invocationContract.getInvokedMode() == ContractMode.IN && invocationContract.getFactoryComponentContract().getMode() == ContractMode.OUT) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidFactoryComponentContract", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract in In Mode couldn't be assigned to a FactoryComponentContract in Out Mode"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidFactoryComponentContractType(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getFactoryComponentContract() == null || invocationContract.getFactoryComponentContract().getType() == null) {
            return true;
        }
        if (invocationContract.getInvokedContract() == null || invocationContract.getInvokedContract().getType() == null) {
            return true;
        }
        Type type = invocationContract.getType();
        if (type == null) {
            type = invocationContract.getInvokedContract().getType();
        }
        if (!ClassHelper.asSubClass(invocationContract.getFactoryComponentContract().getType().getType(), type.getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidFactoryComponentContractType", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "FactoryComponentContract Type is not a subtype of Invoked Contract Type"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidOrchestrationParameter(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getOrchestrationParameter() == null || invocationContract.getInvokedContract() == null) {
            return true;
        }
        if (invocationContract.getInvokedContract().getMode() == ContractMode.OUT) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidOrchestrationParameter", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract in Out Mode couldn't be assigned to an OrchestrationParameter"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        if (invocationContract.getSourceInvocationContract() != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidOrchestrationParameter", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract assigned to a SourceInvocationContract couldn't be assigned to an OrchestrationParameter"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        if (invocationContract.getFactoryComponentContract() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidOrchestrationParameter", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "FactoryComponentContract should be in Out Mode when an InvocationContract is either assigned to an OrchestrationParameter and a FactoryComponentContract"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidOrchestrationParameterType(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getOrchestrationParameter() == null || invocationContract.getOrchestrationParameter().getType() == null || invocationContract.getInvokedContract() == null || invocationContract.getInvokedContract().getType() == null) {
            return true;
        }
        Type type = invocationContract.getType();
        if (type == null) {
            type = invocationContract.getInvokedContract().getType();
        }
        if (!ClassHelper.asSubClass(invocationContract.getOrchestrationParameter().getType().getType(), type.getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidOrchestrationParameterType", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "OrchestrationParameter Type is not a subtype of Invoked Contract Type"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidSourceInvocationContract(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getSourceInvocationContract() == null || invocationContract.getInvokedContract() == null) {
            return true;
        }
        if (invocationContract.getInvokedContract().getMode() == ContractMode.OUT) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidSourceInvocationContract", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract in Out Mode couldn't be assigned to a SourceInvocationContract"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        if (invocationContract.getFactoryComponentContract() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidSourceInvocationContract", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract with a SourceInvocationContract couldn't be assigned to a FactoryComponentContract in In or In_Out Mode"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_ValidSourceInvocationContractType(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getSourceInvocationContract() == null || invocationContract.getSourceInvocationContract().getInvokedContract() == null || invocationContract.getSourceInvocationContract().getInvokedContract().getType() == null) {
            return true;
        }
        Type sourceType = invocationContract.getSourceInvocationContract().getType();
        if (sourceType == null) {
            sourceType = invocationContract.getSourceInvocationContract().getInvokedContract().getType();
        }
        if (invocationContract.getInvokedContract() == null || invocationContract.getInvokedContract().getType() == null) {
            return true;
        }
        Type type = invocationContract.getType();
        if (type == null) {
            type = invocationContract.getInvokedContract().getType();
        }
        if (!ClassHelper.asSubClass(sourceType.getType(), type.getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidSourceInvocationContractType", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract Type and SourceInvocationContract Type mismatch"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContract_UselessTypeValue(InvocationContract invocationContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContract.getOrchestrationParameter() == null && invocationContract.getFactoryComponentContract() == null) {
            return true;
        }
        boolean valid = true;
        if (invocationContract.getInvokedMode() == ContractMode.IN_OUT) {
            if (invocationContract.getOrchestrationParameter() != null && invocationContract.getFactoryComponentContract() != null && invocationContract.getType() != null && invocationContract.getType().getValue() != null) {
                valid = false;
            }
        } else if (invocationContract.getType() != null && invocationContract.getType().getValue() != null) {
            valid = false;
        }
        if (!valid) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UselessTypeValue", FcoreValidator.getObjectLabel((EObject)invocationContract, context), "InvocationContract is used in an OrchestrationParameter or a FactoryComponentContract, Value will be ignored"}, new Object[]{invocationContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateContract_UniqueName(Contract contract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (contract.getName() == null) {
            return true;
        }
        boolean collapse = false;
        for (Contract innerContract : contract.getContracts()) {
            if (innerContract == contract || contract.getMode() == ContractMode.IN && innerContract.getMode() == ContractMode.OUT || contract.getMode() == ContractMode.OUT && innerContract.getMode() == ContractMode.IN || !contract.getName().equals(innerContract.getName())) continue;
            collapse = true;
            break;
        }
        if (collapse) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UniqueName", FcoreValidator.getObjectLabel((EObject)contract, context), "Contract Name should be unique in its ContractContainer"}, new Object[]{contract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateContract_UselessMandatoryMode(Contract contract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!contract.isMandatory() || contract.getType() == null || contract.getType().getValue() == null) {
            return true;
        }
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UselessMandatoryMode", FcoreValidator.getObjectLabel((EObject)contract, context), "A Mandatory Contract with a default value is always true"}, new Object[]{contract}, context));
        }
        return false;
    }

    public boolean validateFactoryComponentContract_OutModeIsRestricted(FactoryComponentContract factoryComponentContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (factoryComponentContract.getMode() == ContractMode.IN || factoryComponentContract.getInvocationContracts() == null) {
            return true;
        }
        if (factoryComponentContract.getInvocationContracts().size() > 1) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"OutModeIsRestricted", FcoreValidator.getObjectLabel((EObject)factoryComponentContract, context), "Out or In_Out Contract Mode should have only one assigned InvocationContract"}, new Object[]{factoryComponentContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateContractMode(ContractMode contractMode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

