/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.contentassist.AbstractXMLTagsBasedAssistProcessor;
import org.eclipse.jet.taglib.TagAttributeDefinition;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JETCustomTagAssistProcessor
extends AbstractXMLTagsBasedAssistProcessor {
    private String[] rootTags;
    private String[][] tagAttributes;

    public JETCustomTagAssistProcessor(JETTextEditor editor) {
        super(editor);
    }

    public String[] getRootTags() {
        if (this.rootTags == null) {
            ArrayList<String> tagNames = new ArrayList<String>();
            String[] tagLibIds = TagLibraryManager.getInstance().getKnownLibraryIds();
            int i = 0;
            while (i < tagLibIds.length) {
                String id = tagLibIds[i];
                TagLibrary tagLib = TagLibraryManager.getInstance().getTagLibrary(id, true);
                String[] names = tagLib.getTagNames();
                int j = 0;
                while (j < names.length) {
                    String name = names[j];
                    tagNames.add(String.valueOf(tagLib.getDefaultPrefix()) + ":" + name);
                    ++j;
                }
                ++i;
            }
            this.rootTags = new String[tagNames.size()];
            tagNames.toArray(this.rootTags);
        }
        return this.rootTags;
    }

    public String[][] getTagAttributes() {
        if (this.tagAttributes == null) {
            HashMap<String, String[]> tagAttributesMap = new HashMap<String, String[]>();
            String[] tagLibIds = TagLibraryManager.getInstance().getKnownLibraryIds();
            int i = 0;
            while (i < tagLibIds.length) {
                String id = tagLibIds[i];
                TagLibrary tagLib = TagLibraryManager.getInstance().getTagLibrary(id, true);
                String[] names = tagLib.getTagNames();
                int j = 0;
                while (j < names.length) {
                    String name = names[j];
                    TagDefinition tagDef = tagLib.getTagDefinition(name);
                    List tagAttributeDefinitions = tagDef.getAttributeDefinitions();
                    String[] attributeNames = new String[tagAttributeDefinitions.size() + 1];
                    attributeNames[0] = String.valueOf(tagLib.getDefaultPrefix()) + ":" + name;
                    int cpt = 1;
                    for (TagAttributeDefinition tagAttributeDef : tagAttributeDefinitions) {
                        attributeNames[cpt++] = tagAttributeDef.getName();
                    }
                    tagAttributesMap.put(String.valueOf(tagLib.getDefaultPrefix()) + ":" + name, attributeNames);
                    ++j;
                }
                ++i;
            }
            int cpt = 0;
            this.tagAttributes = new String[tagAttributesMap.size()][];
            for (String tagName : tagAttributesMap.keySet()) {
                String[] attributeNames = (String[])tagAttributesMap.get(tagName);
                this.tagAttributes[cpt++] = attributeNames;
            }
        }
        return this.tagAttributes;
    }

    protected char getRootTagPrevChar() {
        return '<';
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

