/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.AssemblyHelper;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.jet.engine.JetAssemblyContentProvider;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JetAssemblyHelper
extends AssemblyHelper {
    public static final String START_METHOD_DECLARATION_MARKER = "//Start of methods";
    public static final String END_METHOD_DECLARATION_MARKER = "//End of methods";
    public static final String START_LOOP_MARKER = "//Start of work";
    public static final String END_LOOP_MARKER = "//End of work";
    public static final String START_INIT_VARIABLE_MARKER = "//Start of init";
    public static final String END_INIT_VARIABLE_MARKER = "//End of init";
    public static final String CONSTRUCTOR_MARKER = "//Here is the constructor";

    public JetAssemblyHelper(Pattern pattern, JetAssemblyContentProvider contentProvider) {
        super(pattern, (AssemblyContentProvider)contentProvider);
    }

    protected void beginOrchestration() throws PatternException {
        this.content.append("<%");
        this.content.append("InternalPatternContext ctx = (InternalPatternContext)argument;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("Map<String, String> queryCtx = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("IQuery.ParameterDescription paramDesc = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("%>");
        super.beginOrchestration();
        this.content.append("<%").append(START_LOOP_MARKER).append("%>");
    }

    protected void endOrchestration() throws PatternException {
        String local;
        this.content.append("<%").append(END_LOOP_MARKER).append("%>");
        if (this.pattern.getAllParameters().isEmpty()) {
            this.content.append("<%if (ctx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("    ctx.getReporter().executionFinished(ctx.getExecutionBuffer().toString(), ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("    ctx.clearBuffer();}%>").append(EGFCommonConstants.LINE_SEPARATOR);
            return;
        }
        StringBuilder localContent = new StringBuilder(300);
        localContent.append("<%").append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            this.appendQueryCode(localContent, parameter);
        }
        localContent.append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            local = PatternHelper.localizeName((PatternParameter)parameter);
            localContent.append("for (Object ").append(local).append(" : ").append(this.getParameterListName(parameter)).append(" ) {").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        localContent.append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            local = PatternHelper.localizeName((PatternParameter)parameter);
            String type = ParameterTypeHelper.INSTANCE.getSourceTypeLiteral(parameter.getType());
            localContent.append("this.").append(parameter.getName()).append(" = (").append(type).append(")").append(local).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        localContent.append(EGFCommonConstants.LINE_SEPARATOR).append("%>");
        this.content.insert(this.orchestrationIndex, localContent);
        this.content.append("<%").append(EGFCommonConstants.LINE_SEPARATOR);
        int i = 0;
        while (i < this.pattern.getAllParameters().size()) {
            this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
            ++i;
        }
        this.content.append("if (ctx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ctx.getReporter().executionFinished(ctx.getExecutionBuffer().toString(), ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ctx.clearBuffer();").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}%>");
        int startIndex = this.content.indexOf(START_LOOP_MARKER);
        if (startIndex == -1) {
            throw new PatternException(Messages.assembly_error2);
        }
    }

    private String getParameterListName(PatternParameter parameter) {
        return String.valueOf(parameter.getName()) + "List";
    }

    private void appendQueryCode(StringBuilder localContent, PatternParameter parameter) throws PatternException {
        Query query = parameter.getQuery();
        if (query == null) {
            localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
            localContent.append("//this pattern can only be called by another (i.e. it's not an entry point in execution)").append(EGFCommonConstants.LINE_SEPARATOR);
            return;
        }
        localContent.append("paramDesc = new IQuery.ParameterDescription(\"").append(parameter.getName()).append("\", \"").append(parameter.getType()).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
        localContent.append("queryCtx = new HashMap<String, String>();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (query.getQueryContext() != null) {
            for (String key : query.getQueryContext().keySet()) {
                localContent.append("queryCtx.put(\"").append(key).append("\", \"").append((String)query.getQueryContext().get((Object)key)).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = ");
        localContent.append("QueryHelper.load(ctx, \"").append(query.getExtensionId()).append("\").execute(paramDesc, queryCtx, ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void addVariableInitialization() throws PatternException {
        this.content.append("<%").append(START_INIT_VARIABLE_MARKER).append("%>");
        this.content.append(this.contentHelper.getMethodContent(this.pattern.getInitMethod()));
        this.content.append("<%").append(END_INIT_VARIABLE_MARKER).append("%>");
    }
}

