/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.diagnostic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.EGFDiagnosticDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFValidator {
    private static ValidateAction.EclipseResourcesUtil __eclipseResourcesUtil = new ValidateAction.EclipseResourcesUtil();
    private Map<Resource, UniqueEList<Diagnostic>> _diagnostics;
    private List<? extends EObject> _eObjects = new ArrayList<EObject>();
    private ProjectBundleSession _session;

    public EGFValidator(List<? extends EObject> eObjects) {
        this._eObjects = eObjects;
    }

    public EGFValidator(List<? extends EObject> eObjects, ProjectBundleSession session) {
        Assert.isNotNull((Object)session);
        this._eObjects = eObjects;
        this._session = session;
    }

    public Diagnostic validate() {
        if (this._eObjects == null || this._eObjects.size() == 0) {
            return Diagnostic.OK_INSTANCE;
        }
        this._diagnostics = new HashMap<Resource, UniqueEList<Diagnostic>>();
        final Diagnostic[] diagnostic = new Diagnostic[1];
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    diagnostic[0] = EGFValidator.this.validate(monitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            for (Resource resource : EGFValidator.this._diagnostics.keySet()) {
                                __eclipseResourcesUtil.deleteMarkers((Object)resource);
                            }
                            int severity = diagnostic[0].getSeverity();
                            if (severity == 4 || severity == 2) {
                                EGFValidator.handleDiagnostic(EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title"), EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message"), diagnostic[0]);
                            }
                            for (Resource resource : EGFValidator.this._diagnostics.keySet()) {
                                for (Diagnostic childDiagnostic : (UniqueEList)EGFValidator.this._diagnostics.get(resource)) {
                                    __eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
                                }
                            }
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
        };
        runnableWithProgress = new WorkspaceModifyDelegatingOperation(runnableWithProgress);
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
        return diagnostic[0];
    }

    protected Diagnostic validate(IProgressMonitor monitor) {
        int selectionSize;
        int count = selectionSize = this._eObjects.size();
        for (EObject eObject : this._eObjects) {
            TreeIterator i = eObject.eAllContents();
            while (i.hasNext()) {
                EObject innerEObject = (EObject)i.next();
                if (innerEObject.eResource() != null && this._diagnostics.get(innerEObject.eResource()) == null) {
                    this._diagnostics.put(innerEObject.eResource(), (UniqueEList<Diagnostic>)new UniqueEList());
                }
                ++count;
            }
        }
        monitor.beginTask("", count);
        Diagnostician diagnostician = this.createDiagnostician(monitor);
        String message = NLS.bind((String)CoreUIMessages._UI_DiagnosisOfNObjects_message, (Object)Integer.toString(selectionSize));
        if (this._eObjects.size() == 1) {
            message = NLS.bind((String)CoreUIMessages._UI_DiagnosisOfNObject_message, (Object)EMFHelper.getText((Object)this._eObjects.get(0)));
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic(EGFCoreUIPlugin.getDefault().getPluginID(), 0, message, this._eObjects.toArray());
        Map context = diagnostician.createDefaultContext();
        IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.egf.core.model.validate.types")) {
            context.put("org.eclipse.egf.core.model.validate.types", Boolean.TRUE);
        } else {
            context.put("org.eclipse.egf.core.model.validate.types", Boolean.FALSE);
        }
        ProjectBundleSession session = this._session;
        if (this._session == null) {
            session = new ProjectBundleSession(EGFCoreUIPlugin.getDefault().getBundle().getBundleContext());
        }
        context.put(ProjectBundleSession.PROJECT_BUNDLE_SESSION, session);
        for (EObject eObject : this._eObjects) {
            monitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
            diagnostician.validate(eObject, (DiagnosticChain)diagnostic, context);
        }
        try {
            if (this._session == null) {
                session.dispose();
            }
        }
        catch (CoreException coreException) {
            EGFCoreUIPlugin.getDefault().logError(coreException);
        }
        for (Diagnostic diagnostic2 : diagnostic.getChildren()) {
            List data = diagnostic2.getData();
            if (data.isEmpty() || !(data.get(0) instanceof EObject) || ((EObject)data.get(0)).eResource() == null) continue;
            EObject eObject = (EObject)data.get(0);
            UniqueEList diagnostics = this._diagnostics.get(eObject.eResource());
            if (diagnostics == null) {
                diagnostics = new UniqueEList();
                this._diagnostics.put(eObject.eResource(), (UniqueEList<Diagnostic>)diagnostics);
            }
            diagnostics.add((Object)diagnostic2);
        }
        return diagnostic;
    }

    protected Diagnostician createDiagnostician(final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                return EMFHelper.getText((Object)eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    public static void handleDiagnostic(String title, String message, Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 0) {
            return;
        }
        int result = 0;
        EGFDiagnosticDialog dialog = new EGFDiagnosticDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, diagnostic, 7);
        result = dialog.open();
        if (result != 0) {
            return;
        }
        if (dialog.getSelection() == null || dialog.getSelection().isEmpty()) {
            return;
        }
        HashMap<Resource, List> resources = new HashMap<Resource, List>();
        for (Diagnostic innerDiagnostic : dialog.getSelection()) {
            List data = innerDiagnostic.getData();
            if (data.isEmpty() || !(data.get(0) instanceof EObject) || ((EObject)data.get(0)).eResource() == null) continue;
            EObject eObject = (EObject)data.get(0);
            List eObjects = (List)resources.get(eObject.eResource());
            if (eObjects == null) {
                eObjects = new UniqueEList();
                resources.put(eObject.eResource(), eObjects);
            }
            eObjects.add(eObject);
        }
        EditorHelper.openEditorsAndSelect(resources);
    }
}

