/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.emf.common.util.URI;

public class JavaNatureHelper {
    private static final Pattern compile = Pattern.compile("\\s*package\\s*([\\w\\.]*);.*class\\s+(\\w*).*", 40);

    public static String getPackageName(org.eclipse.egf.model.pattern.Pattern pattern) throws PatternException {
        try {
            String content = FileHelper.getContent((IPlatformFcore)PatternHelper.getPlatformFcore((PatternElement)pattern), (URI)pattern.getHeaderMethod().getPatternFilePath());
            Matcher matcher = compile.matcher(content);
            if (matcher.matches()) {
                String pack = matcher.group(1);
                if ("".equals(pack)) {
                    throw new PatternException(Messages.bind((String)Messages.assembly_error8, (Object)pattern.getName()));
                }
                return pack;
            }
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
        throw new PatternException(Messages.bind((String)Messages.assembly_error6, (Object)pattern.getName()));
    }

    public static String getClassName(org.eclipse.egf.model.pattern.Pattern pattern) throws PatternException {
        try {
            String content = FileHelper.getContent((IPlatformFcore)PatternHelper.getPlatformFcore((PatternElement)pattern), (URI)pattern.getHeaderMethod().getPatternFilePath());
            Matcher matcher = compile.matcher(content);
            if (matcher.matches()) {
                String pack = matcher.group(1);
                String cls = matcher.group(2);
                if ("".equals(pack) || "".equals(cls)) {
                    throw new PatternException(Messages.bind((String)Messages.assembly_error8, (Object)pattern.getName()));
                }
                return String.valueOf(pack) + "." + cls;
            }
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
        throw new PatternException(Messages.bind((String)Messages.assembly_error6, (Object)pattern.getName()));
    }

    private JavaNatureHelper() {
    }
}

