/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.ui.contributor.DefaultPropertyEditorContributor;
import org.eclipse.egf.core.ui.dialogs.SubTypeSelectionExtension;
import org.eclipse.egf.core.ui.dialogs.TypeSelectionDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTypeEditorContributor
extends DefaultPropertyEditorContributor {
    public CellEditor createPropertyEditor(final Composite composite, Object object, IItemPropertyDescriptor descriptor) {
        final String value = this.getValue(object);
        final String filteredType = this.getFilteredType(object);
        final Resource resource = ((EObject)object).eResource();
        return new ExtendedDialogCellEditor(composite, this.getLabelProvider(object, descriptor)){

            protected Object openDialogBox(Control cellEditorWindow) {
                IJavaProject javaProject = EMFHelper.getJavaProject((Resource)resource);
                if (javaProject == null) {
                    return value;
                }
                IType type = null;
                try {
                    type = javaProject.findType(filteredType, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)ce);
                    return value;
                }
                if (type == null) {
                    return value;
                }
                try {
                    TypeSelectionDialog dialog = new TypeSelectionDialog(composite.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), javaProject, 10, (TypeSelectionExtension)new SubTypeSelectionExtension(type));
                    dialog.setTitle(NLS.bind((String)CoreUIMessages._UI_SelectType, (Object)filteredType));
                    if (dialog.open() != 0) {
                        String string = value;
                        return string;
                    }
                    Object innerResult = dialog.getFirstResult();
                    if (innerResult instanceof IType) {
                        String string = ((IType)innerResult).getFullyQualifiedName();
                        return string;
                    }
                }
                catch (Throwable t) {
                    ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)t);
                }
                finally {
                    try {
                        javaProject.close();
                    }
                    catch (JavaModelException jme) {
                        ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)jme);
                    }
                }
                return value;
            }
        };
    }

    protected abstract String getFilteredType(Object var1);

    protected abstract String getValue(Object var1);
}

