/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import java.util.List;
import org.eclipse.egf.core.ui.contributor.DefaultPropertyEditorContributor;
import org.eclipse.egf.core.ui.dialogs.LoadEcoreDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.domain.DomainPackage;
import org.eclipse.egf.model.domain.DomainURI;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DomainURIEditorContributor
extends DefaultPropertyEditorContributor {
    public boolean canApply(Object object, IItemPropertyDescriptor descriptor) {
        return this.checkFeature(object, descriptor, (EStructuralFeature)DomainPackage.Literals.DOMAIN_URI__URI) && object instanceof DomainURI;
    }

    public CellEditor createPropertyEditor(Composite composite, Object object, IItemPropertyDescriptor descriptor) {
        final DomainURI domainURI = (DomainURI)object;
        final EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)domainURI);
        if (editingDomain == null) {
            return null;
        }
        return new ExtendedDialogCellEditor(composite, this.getLabelProvider(object, descriptor)){

            protected Object openDialogBox(Control control) {
                LoadEcoreDialog dialog = new LoadEcoreDialog(control.getShell(), editingDomain){

                    protected Control createDialogArea(Composite parent) {
                        Control innerControl = super.createDialogArea(parent);
                        if (domainURI.getUri() != null) {
                            this.uriField.setText(domainURI.getUri().toString());
                        }
                        return innerControl;
                    }

                    protected void configureShell(Shell shell) {
                        this.title = CoreUIMessages._UI_PackageSelection_label;
                        super.configureShell(shell);
                    }
                };
                if (dialog.open() == 0) {
                    List results = dialog.getURIs();
                    if (results != null && results.size() > 0) {
                        return results.get(0);
                    }
                    return URI.createURI((String)"");
                }
                return domainURI.getUri();
            }

            protected void doSetValue(Object value) {
                if (value != null && "".equals(value.toString())) {
                    super.doSetValue(null);
                } else {
                    super.doSetValue(value);
                }
            }
        };
    }
}

