/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.jet.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.pattern.ui.jet.editor.JETAnnotationModel;
import org.eclipse.egf.pattern.ui.jet.editor.JetEditorHelper;
import org.eclipse.egf.pattern.ui.jet.editor.JetTextEditor;
import org.eclipse.egf.pattern.ui.jet.template.JetTemplateEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.annotations.JETProblemAnnotation;
import org.eclipse.jet.internal.editor.configuration.JETReconcilingStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JetReconcilingStrategy
extends JETReconcilingStrategy {
    private JETTextEditor jetEditor;
    private ISourceViewer sourceViewer;

    public JetReconcilingStrategy(ISourceViewer sourceViewer, JETTextEditor jetEditor) {
        super(sourceViewer, jetEditor);
        this.jetEditor = jetEditor;
        this.sourceViewer = sourceViewer;
    }

    private void internalReconcile() {
        JetTextEditor jetTextEditor = null;
        JETCompilationUnit cUnit = this.jetEditor.requestCompilationUnit();
        List cUnitProblems = cUnit.getProblems();
        IEditorInput editorInput = this.jetEditor.getEditorInput();
        String name = editorInput.getName();
        Map<String, List<Problem>> methodProblems = JetTemplateEditor.getMethodProblems();
        List<Object> javaContentProblems = new ArrayList();
        if (methodProblems != null && !methodProblems.isEmpty() && methodProblems.containsKey(name)) {
            javaContentProblems = methodProblems.get(name);
        }
        List evaluateProblems = JETEditorHelper.evaluateProblems((JETTextEditor)this.jetEditor, (IDocument)this.sourceViewer.getDocument());
        for (Problem next : evaluateProblems) {
            if (javaContentProblems.contains(next)) continue;
            javaContentProblems.add(next);
        }
        if (this.jetEditor instanceof JetTextEditor) {
            jetTextEditor = (JetTextEditor)this.jetEditor;
        }
        EList allParameters = jetTextEditor.getPattern().getAllParameters();
        EList allVariables = jetTextEditor.getPattern().getAllVariables();
        javaContentProblems = JetEditorHelper.clearProblemsForParameterAndVariable(allParameters, javaContentProblems);
        javaContentProblems = JetEditorHelper.clearProblemsForParameterAndVariable(allVariables, javaContentProblems);
        IAnnotationModel annotationModelq = this.sourceViewer.getAnnotationModel();
        JETAnnotationModel annotationModel = (JETAnnotationModel)annotationModelq;
        if (annotationModel != null) {
            Position position;
            JETProblemAnnotation annotation;
            annotationModel.setFireChanges(false);
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation2 = (Annotation)it.next();
                if (!(annotation2 instanceof JETProblemAnnotation) && !(annotation2 instanceof MarkerAnnotation)) continue;
                annotationModel.removeAnnotation(annotation2);
            }
            for (Problem problem : cUnitProblems) {
                annotation = new JETProblemAnnotation(problem);
                position = new Position(problem.getStart(), problem.getEnd() - problem.getStart());
                annotationModel.addAnnotation((Annotation)annotation, position);
            }
            for (Problem problem : javaContentProblems) {
                annotation = new JETProblemAnnotation(problem);
                position = new Position(problem.getStart(), problem.getEnd() - problem.getStart());
                annotationModel.addAnnotation((Annotation)annotation, position);
            }
            annotationModel.setFireChanges(true);
            annotationModel.fireAnnotationModelChanged();
        }
    }

    public void setDocument(IDocument idocument) {
    }

    public void initialReconcile() {
        this.internalReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.internalReconcile();
    }

    public void reconcile(IRegion partition) {
        JetTextEditor jetTextEditor = (JetTextEditor)this.jetEditor;
        JetEditorHelper.refreshPublicTemplateEditor(jetTextEditor);
        JetEditorHelper.mappingErrorFromTemplateEditor(jetTextEditor);
    }

    public void setProgressMonitor(IProgressMonitor iprogressmonitor) {
    }
}

