/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHelper {
    private JavaHelper() {
    }

    public static String dropNonWordCharacterWith(String value, String replacement) {
        if (value == null) {
            return null;
        }
        if (replacement != null) {
            return value.replaceAll("\\W", replacement);
        }
        return JavaHelper.dropNonWordCharacter(value);
    }

    public static String dropNonWordCharacter(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("\\W", "");
    }

    public static String dropNonWordCharacterExcept(String value, String except) {
        if (value == null) {
            return null;
        }
        if (except != null) {
            return value.replaceAll("\\W^" + except, "");
        }
        return JavaHelper.dropNonWordCharacter(value);
    }

    private static IFolder findFolder(IPath path) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null || !(resource instanceof IFolder)) {
            return null;
        }
        return (IFolder)resource;
    }

    public static String getFileName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return "/" + clazz.getName().replaceAll("[.]", "/") + ".class";
    }

    public static URL getResourceURL(Class<?> clazz) {
        try {
            String name = JavaHelper.getFileName(clazz);
            if (name == null) {
            }
            return clazz.getResource(name);
        }
        finally {
            return null;
        }
    }

    public static URL getFileURL(Class<?> clazz) {
        String name;
        block4: {
            name = JavaHelper.getFileName(clazz);
            if (name != null) break block4;
            return null;
        }
        try {
            URL url = clazz.getResource(name);
            if (url != null) {
                return FileLocator.resolve((URL)url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ClassLoader getProjectClassLoader(IJavaProject project) throws CoreException {
        final List<URL> urls = JavaHelper.getProjectURLs(project, new HashSet<IJavaProject>());
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), JavaHelper.class.getClassLoader()){

                    @Override
                    public final synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        int i;
                        SecurityManager sm = System.getSecurityManager();
                        if (sm != null && (i = name.lastIndexOf(46)) != -1) {
                            sm.checkPackageAccess(name.substring(0, i));
                        }
                        return super.loadClass(name, resolve);
                    }
                };
            }
        });
    }

    public static List<URL> getProjectURLs(IJavaProject javaProject, Set<IJavaProject> visited) throws CoreException {
        UniqueEList urls = new UniqueEList();
        if (visited.contains(javaProject)) {
            return urls;
        }
        visited.add(javaProject);
        try {
            IFolder folder = JavaHelper.findFolder(javaProject.getOutputLocation());
            if (folder != null) {
                urls.add(new URL("file://" + folder.getLocation().toOSString() + '/'));
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathContainer classpathContainer;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    folder = JavaHelper.findFolder(entry.getOutputLocation());
                    if (folder != null) {
                        urls.add(new URL("file://" + folder.getLocation().toOSString() + '/'));
                    }
                } else if (entry.getEntryKind() == 2) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString());
                    IJavaProject innerJavaProject = JavaCore.create((IProject)project);
                    if (project.exists()) {
                        urls.addAll(JavaHelper.getProjectURLs(innerJavaProject, visited));
                    }
                } else if (entry.getEntryKind() == 1 || entry.getEntryKind() == 4) {
                    urls.add(JavaHelper.getURL(entry.getPath()));
                } else if (entry.getEntryKind() == 5 && (classpathContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject)) != null) {
                    IClasspathEntry[] iClasspathEntryArray2 = classpathContainer.getClasspathEntries();
                    int n3 = iClasspathEntryArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry classpathEntry = iClasspathEntryArray2[n4];
                        urls.add(JavaHelper.getURL(classpathEntry.getPath()));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCommonMessages.JavaHelper_AnalysingFailure, (Object)javaProject.getProject().getName()), t));
        }
        return urls;
    }

    private static URL getURL(IPath entry) throws MalformedURLException {
        String path = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath location = root.getFile(entry).getLocation();
        if (location != null) {
            path = location.toOSString();
        }
        if (path == null) {
            path = entry.toOSString();
        }
        if (entry.toFile() != null && !entry.toFile().isDirectory()) {
            return new URL("file://" + path);
        }
        return new URL("file://" + path + '/');
    }

    public static List<IFolder> getOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IFolder folder = JavaHelper.findFolder(project.getOutputLocation());
        if (folder != null) {
            folders.add(folder);
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = JavaHelper.findFolder(entry.getOutputLocation())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<String> getStringOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList outputFoldersAsString = new UniqueEList();
        if (!project.exists()) {
            return outputFoldersAsString;
        }
        List<IFolder> outputFolders = JavaHelper.getOutputFolders(project);
        for (IFolder outputFolder : outputFolders) {
            outputFoldersAsString.add(outputFolder.getFullPath().removeFirstSegments(1).toString());
        }
        return outputFoldersAsString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteJavaResource(IProgressMonitor monitor, IProject project, String folderName, String packageName, String className, boolean deleteParent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        subMonitor.beginTask(null, 200);
        if (project == null || packageName == null) {
            subMonitor.worked(200);
            return false;
        }
        IJavaProject javaProject = null;
        try {
            if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
            }
            if (javaProject == null) {
                subMonitor.worked(200);
                return false;
            }
            IFolder root = JavaHelper.getSourceFolder(javaProject, folderName);
            if (root == null) {
                subMonitor.worked(200);
                return false;
            }
            IResource resource = null;
            IContainer container = null;
            if (className != null) {
                IPath targetPath = new Path(FileHelper.convertPackageNameToFolderPath(packageName)).append(String.valueOf(className) + ".java");
                resource = root.findMember(targetPath);
            } else {
                Path targetPath = new Path(FileHelper.convertPackageNameToFolderPath(packageName));
                container = (IContainer)root.findMember((IPath)targetPath);
            }
            if (resource != null && resource.exists()) {
                boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(200, 0), root, resource, deleteParent);
                return bl;
            }
            if (container != null && container.exists() && (container.members() == null || container.members().length == 0)) {
                boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(200, 0), root, (IResource)container, deleteParent);
                return bl;
            }
            subMonitor.worked(200);
            return true;
        }
        finally {
            try {
                javaProject.close();
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean moveJavaResource(IProgressMonitor monitor, IProject project, String folderName, String oldPackageName, String oldClassName, String newPackageName, String newClassName, boolean deleteParent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        subMonitor.beginTask(null, 200);
        if (project == null || oldPackageName == null || newPackageName == null) {
            subMonitor.worked(200);
            return false;
        }
        IJavaProject javaProject = null;
        try {
            if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
            }
            if (javaProject == null) {
                subMonitor.worked(200);
                return false;
            }
            IFolder root = JavaHelper.getSourceFolder(javaProject, folderName);
            if (root == null) {
                subMonitor.worked(200);
                return false;
            }
            IResource resourceToMove = null;
            IContainer container = null;
            if (oldClassName != null) {
                resourceToMove = root.findMember(new Path(FileHelper.convertPackageNameToFolderPath(oldPackageName)).append(String.valueOf(oldClassName) + ".java"));
                container = (IContainer)root.findMember((IPath)new Path(FileHelper.convertPackageNameToFolderPath(oldPackageName)));
            } else {
                resourceToMove = root.findMember((IPath)new Path(FileHelper.convertPackageNameToFolderPath(oldPackageName)));
                if (resourceToMove != null && resourceToMove.exists()) {
                    container = resourceToMove.getParent();
                }
            }
            if (resourceToMove == null || !resourceToMove.exists()) {
                subMonitor.worked(200);
                return false;
            }
            if (newClassName != null) {
                IPath targetPath = new Path(FileHelper.convertPackageNameToFolderPath(newPackageName)).append(String.valueOf(newClassName) + ".java");
                IResource targetResource = root.findMember(targetPath);
                if (targetResource != null && targetResource.exists()) {
                    boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(200, 0), root, resourceToMove, deleteParent);
                    return bl;
                }
                resourceToMove.move(root.getFullPath().append(targetPath), false, (IProgressMonitor)subMonitor.newChild(100, 0));
            } else {
                IPath targetPath = root.getFullPath().append((IPath)new Path(FileHelper.convertPackageNameToFolderPath(newPackageName)));
                resourceToMove.move(targetPath, false, (IProgressMonitor)subMonitor.newChild(100, 0));
            }
            if (container != null && container.exists() && (container.members() == null || container.members().length == 0)) {
                boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(100, 0), root, (IResource)container, deleteParent);
                return bl;
            }
            subMonitor.worked(100);
            return true;
        }
        finally {
            try {
                javaProject.close();
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public static IFile getSourceFile(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null || !(resource instanceof IFile)) continue;
            return (IFile)resource;
        }
        return null;
    }

    public static IFolder getSourceFolder(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null) continue;
            return folder;
        }
        return null;
    }

    public static IFolder getSourceFolder(IJavaProject project, String name) throws CoreException {
        if (project == null || name == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public static List<IFolder> getSourceFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = JavaHelper.findFolder(entry.getPath())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<IFolder> getSourceAndOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        folders.addAll(JavaHelper.getSourceFolders(project));
        folders.addAll(JavaHelper.getOutputFolders(project));
        return folders;
    }
}

