/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class URIHelper {
    public static final URI PLATFORM_PLUGIN_URI = URI.createURI((String)"platform:/plugin/");
    public static final URI PLATFORM_RESOURCE_URI = URI.createURI((String)"platform:/resource/");

    private URIHelper() {
    }

    public static String toString(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.isPlatformPlugin() || uri.isPlatformResource()) {
            String fragment = uri.fragment();
            URI encodedURI = null;
            if (uri.isPlatformPlugin()) {
                String pathName = URI.decode((String)uri.trimFragment().toString().substring(PLATFORM_PLUGIN_URI.toString().length(), uri.trimFragment().toString().length()));
                encodedURI = URI.createPlatformPluginURI((String)pathName, (boolean)true);
            } else {
                String pathName = URI.decode((String)uri.trimFragment().toString().substring(PLATFORM_RESOURCE_URI.toString().length(), uri.trimFragment().toString().length()));
                encodedURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
            }
            if (fragment != null) {
                encodedURI = encodedURI.appendFragment(fragment);
            }
            return encodedURI.toString();
        }
        return uri.toString();
    }

    public static URI getPlatformPluginURI(IPluginModelBase model, String value) {
        if (model == null || value == null || value.trim().length() == 0) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId(model);
        if (bundleId == null) {
            return null;
        }
        return URIHelper.getPlatformPluginURI(bundleId, URI.decode((String)value.trim()), false);
    }

    public static URI getPlatformPluginURI(IPath path) {
        if (path == null || path.segmentCount() < 2) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (project == null) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId(project);
        if (bundleId == null) {
            return null;
        }
        return URIHelper.getPlatformPluginURI(bundleId, path.removeFirstSegments(1).toString(), false);
    }

    public static URI getPlatformPluginURI(IResource resource) {
        if (resource == null || resource.getFullPath() == null || resource.getFullPath().segmentCount() < 2) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId(resource);
        if (bundleId == null) {
            return null;
        }
        return URIHelper.getPlatformPluginURI(bundleId, resource.getFullPath().removeFirstSegments(1).toString(), false);
    }

    public static URI getPlatformPluginURI(String bundleId, String value, boolean encode) {
        if (bundleId == null || bundleId.trim().length() == 0 || value == null || value.trim().length() == 0) {
            return null;
        }
        URI uri = URI.createURI((String)value.trim());
        if (uri.isRelative()) {
            uri = value.trim().charAt(0) == '/' ? URI.createPlatformPluginURI((String)(String.valueOf(bundleId.trim()) + uri.toString()), (boolean)encode) : URI.createPlatformPluginURI((String)(String.valueOf(bundleId.trim()) + "/" + uri.toString()), (boolean)encode);
        }
        return uri;
    }

    public static URI getPlatformResourceURI(String bundleId, String value, boolean encode) {
        if (bundleId == null || bundleId.trim().length() == 0 || value == null || value.trim().length() == 0) {
            return null;
        }
        URI uri = URI.createURI((String)value.trim());
        if (uri.isRelative()) {
            uri = value.trim().charAt(0) == '/' ? URI.createPlatformResourceURI((String)(String.valueOf(bundleId.trim()) + uri.toString()), (boolean)encode) : URI.createPlatformResourceURI((String)(String.valueOf(bundleId.trim()) + "/" + uri.toString()), (boolean)encode);
        }
        return uri;
    }

    public static String toPlatformProjectString(URI uri, boolean decode) {
        if (uri != null && uri.isPlatform() && uri.segmentCount() > 2) {
            StringBuffer result = new StringBuffer();
            int i = 2;
            int len = uri.segmentCount();
            while (i < len) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(decode ? URI.decode((String)uri.segment(i)) : uri.segment(i));
                ++i;
            }
            return result.toString();
        }
        return null;
    }
}

