/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain.file;

import java.util.Arrays;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.DomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.WorkspaceDomain;

public class WorkspaceDomainHelper
implements DomainHelper {
    public boolean loadDomain(Domain domain) throws DomainException {
        if (domain instanceof WorkspaceDomain) {
            Path path2;
            WorkspaceDomain myDomain;
            block8: {
                myDomain = (WorkspaceDomain)domain;
                String path = myDomain.getPath();
                if (myDomain.isLoaded()) {
                    throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
                }
                myDomain.setLoaded(true);
                if (path == null || "".equals(path)) {
                    Activator.getDefault().logWarning(Messages.bind((String)Messages.Load_WorkspaceDomain_error1, (Object)domain.getName()));
                    return true;
                }
                if (!myDomain.getContent().isEmpty()) {
                    throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
                }
                if (".".equals(path)) {
                    myDomain.getContent().addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                    return true;
                }
                path2 = new Path(path);
                int segmentCount = path2.segmentCount();
                try {
                    if (segmentCount != 1) break block8;
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path);
                    myDomain.getContent().addAll(Arrays.asList(project.members()));
                    return true;
                }
                catch (CoreException e) {
                    throw new DomainException(Messages.Load_WorkspaceDomain_error2, e);
                }
            }
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path2);
            myDomain.getContent().addAll(Arrays.asList(folder.members()));
            return true;
        }
        return false;
    }

    public boolean unLoadDomain(Domain domain) throws DomainException {
        if (domain instanceof WorkspaceDomain) {
            WorkspaceDomain myDomain = (WorkspaceDomain)domain;
            myDomain.getContent().clear();
            myDomain.setLoaded(false);
            return true;
        }
        return false;
    }
}

