/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.common.java.BaseJavaAssemblyHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.utils.TemplateFileHelper;

public class JavaNatureHelper {
    private static final Pattern compile = Pattern.compile("\\s*package\\s*([\\w\\.]*);.*class\\s+(\\w*).*", 40);

    public static String getClassName(org.eclipse.egf.model.pattern.Pattern pattern) throws PatternException {
        try {
            String content = TemplateFileHelper.getContent((PatternMethod)pattern.getHeaderMethod());
            Matcher matcher = compile.matcher(content);
            if (matcher.matches()) {
                String pack = matcher.group(1);
                String cls = matcher.group(2);
                if ("".equals(pack) || "".equals(cls)) {
                    throw new PatternException(Messages.bind((String)Messages.assembly_error8, (Object)pattern.getName()));
                }
                if ("CLASS".equals(cls) && "PACKAGE".equals(pack)) {
                    return BaseJavaAssemblyHelper.getFullClassName((org.eclipse.egf.model.pattern.Pattern)pattern);
                }
                return String.valueOf(pack) + "." + cls;
            }
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
        throw new PatternException(Messages.bind((String)Messages.assembly_error6, (Object)pattern.getName()));
    }

    private JavaNatureHelper() {
    }
}

