/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.java.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.editors.PatternMethodEditorInput;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditor;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditorHelper;
import org.eclipse.egf.pattern.ui.java.template.JavaTemplateEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaCompositeReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingReconcileStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaTextReconcilingStrategy
extends JavaCompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private JavaReconcilingStrategy fJavaStrategy;
    private RefreshUIJob job;

    public JavaTextReconcilingStrategy(ISourceViewer viewer, ITextEditor editor, String documentPartitioning) {
        super(viewer, editor, documentPartitioning);
        this.fEditor = editor;
        this.fJavaStrategy = new JavaReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fJavaStrategy, new JavaSpellingReconcileStrategy(viewer, editor)});
    }

    private void internalReconcile() {
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        }
        IEditorInput editorInput = this.fEditor.getEditorInput();
        String name = editorInput.getName();
        IAnnotationModel annotationModel = p.getAnnotationModel((Object)this.fEditor.getEditorInput());
        Iterator iter = annotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            annotationModel.removeAnnotation(annotation);
        }
        Map<String, Map<Annotation, Position>> methodJavaAnnotations = JavaTemplateEditor.getMethodJavaAnnotations();
        Map<Object, Object> methodAnnotations = new HashMap();
        if (methodJavaAnnotations != null && !methodJavaAnnotations.isEmpty()) {
            methodAnnotations = methodJavaAnnotations.get(name);
        }
        for (Annotation annotation : methodAnnotations.keySet()) {
            Position position = (Position)methodAnnotations.get(annotation);
            annotationModel.addAnnotation(annotation, position);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        JavaTextEditorHelper.mappingErrorFromTemplateEditor((JavaTextEditor)this.fEditor);
    }

    public void reconcile(IRegion partition) {
        if (JavaTextEditor.refreshJob) {
            if (this.job == null) {
                this.job = new RefreshUIJob("RefreshTemplateEditor");
            }
            this.job.start();
            JavaTextEditor.refreshJob = false;
        }
    }

    public void notifyListeners(boolean notify) {
        this.fJavaStrategy.notifyListeners(notify);
    }

    public void initialReconcile() {
        this.initialMapping();
    }

    private void initialMapping() {
        PatternMethodEditorInput input;
        PatternMethod inputPatternMethod;
        JavaTextEditor javaTextEditor = (JavaTextEditor)this.fEditor;
        EList methods = javaTextEditor.getPattern().getMethods();
        int size = methods.size();
        PatternMethod patternMethod = (PatternMethod)methods.get(size - 1);
        IEditorInput editorInput = javaTextEditor.getEditorInput();
        if (editorInput instanceof PatternMethodEditorInput && patternMethod.equals(inputPatternMethod = (input = (PatternMethodEditorInput)editorInput).getPatternMethod())) {
            JavaTextEditorHelper.mappingErrorFromTemplateEditor((JavaTextEditor)this.fEditor);
        }
    }

    private void reconciled() {
        this.fJavaStrategy.reconciled();
    }

    public void aboutToBeReconciled() {
        super.aboutToBeReconciled();
    }

    class RefreshUIJob
    extends Job {
        private long timestamp;
        private boolean lazy;

        public RefreshUIJob(String name) {
            super(name);
            this.timestamp = -1L;
            this.lazy = false;
        }

        private void start() {
            if (!this.lazy) {
                this.schedule(500L);
            } else if (System.currentTimeMillis() - this.timestamp > 499L && !this.lazy) {
                this.lazy = true;
            }
            this.timestamp = System.currentTimeMillis();
        }

        protected IStatus run(IProgressMonitor monitor) {
            JavaTextEditorHelper.mappingErrorFromTemplateEditor((JavaTextEditor)JavaTextReconcilingStrategy.this.fEditor);
            if (this.lazy) {
                this.schedule();
                this.lazy = false;
            }
            return Status.OK_STATUS;
        }
    }
}

