/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.task.ui.contributions;

import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.task.ui.l10n.EGFTaskUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class TaskImplementationOpenAction
extends Action {
    private final Task task;

    public TaskImplementationOpenAction(Task task, String id) {
        this.task = task;
    }

    protected Task getTask() {
        return this.task;
    }

    protected String getKind() {
        Task innerTask = this.getTask();
        if (innerTask.getKindValue() != null && innerTask.getKindValue().trim().length() != 0) {
            return innerTask.getKindValue().trim();
        }
        return null;
    }

    protected String getImplementation() {
        Task innerTask = this.getTask();
        if (innerTask.getImplementationValue() != null && innerTask.getImplementationValue().trim().length() != 0) {
            return innerTask.getImplementationValue().trim();
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.getTask().eResource() == null) {
            return false;
        }
        if (this.getKind() == null) {
            return false;
        }
        return this.getImplementation() != null && this.getImplementation().length() != 0;
    }

    protected abstract boolean doRun() throws Exception;

    public void run() {
        try {
            if (!this.doRun()) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_error_title, (String)NLS.bind((String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_error_message, (Object)this.getImplementation()));
            }
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Throwable t) {
            ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)t);
            return;
        }
    }
}

