/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.common.java.BaseJavaAssemblyHelper;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyContentProvider;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JavaAssemblyHelper
extends BaseJavaAssemblyHelper {
    public static final String CONSTRUCTOR_MARKER = "//Here is the constructor";

    public JavaAssemblyHelper(Pattern pattern, JavaAssemblyContentProvider contentProvider) {
        super(pattern, (AssemblyContentProvider)contentProvider);
    }

    protected void addVariableInitialization() throws PatternException {
        int indexOf = this.content.indexOf(CONSTRUCTOR_MARKER);
        if (indexOf == -1) {
            throw new IllegalStateException();
        }
        this.content.insert(indexOf + CONSTRUCTOR_MARKER.length() + 1, this.contentHelper.getMethodContent(this.pattern.getInitMethod()));
    }

    protected void beginOrchestration() throws PatternException {
        this.content.append("public void generate (Object argument) throws Exception {").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("InternalPatternContext ctx = (InternalPatternContext)argument;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("IQuery.ParameterDescription paramDesc = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("Map<String, String> queryCtx = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        super.beginOrchestration();
        if (!this.pattern.getAllParameters().isEmpty()) {
            String local;
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                this.appendQueryCode(this.content, parameter);
            }
            this.content.append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                this.content.append("for (Object ").append(local).append(" : ").append(this.getParameterListName(parameter)).append(" ) {").append(EGFCommonConstants.LINE_SEPARATOR);
            }
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                String type = ParameterTypeHelper.INSTANCE.getSourceTypeLiteral(parameter.getType());
                this.content.append("this.").append(parameter.getName()).append(" = (").append(type).append(")").append(local).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
            if (this.pattern.getConditionMethod() != null) {
                this.content.append(EGFCommonConstants.LINE_SEPARATOR);
                this.content.append("if (preCondition())");
            }
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("orchestration").append("((PatternContext)argument);").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
            int i = 0;
            while (i < this.pattern.getAllParameters().size()) {
                this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
                ++i;
            }
        } else {
            if (this.pattern.getConditionMethod() != null) {
                this.content.append(EGFCommonConstants.LINE_SEPARATOR);
                this.content.append("if (preCondition())");
            }
            this.content.append(EGFCommonConstants.LINE_SEPARATOR).append("orchestration").append("((PatternContext)argument);").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.append("if (ctx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ctx.getReporter().executionFinished(ctx.getExecutionBuffer().toString(), ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ctx.clearBuffer();}").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("public String ").append("orchestration").append("(PatternContext ctx) throws Exception {").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("InternalPatternContext ictx = (InternalPatternContext)ctx;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("int executionIndex = ictx.getExecutionBuffer().length();").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void endOrchestration() throws PatternException {
        this.content.append(EGFCommonConstants.LINE_SEPARATOR).append("String loop = ictx.getBuffer().toString();").append(EGFCommonConstants.LINE_SEPARATOR);
        boolean hasParameter = !this.pattern.getAllParameters().isEmpty();
        this.content.append("if (ictx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ictx.getExecutionBuffer().append(ictx.getBuffer().substring(ictx.getExecutionCurrentIndex()));").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ictx.setExecutionCurrentIndex(0);").append(EGFCommonConstants.LINE_SEPARATOR);
        if (hasParameter) {
            this.content.append("Map<String, Object> parameterValues = new HashMap<String, Object>();").append(EGFCommonConstants.LINE_SEPARATOR);
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                this.content.append("parameterValues.put(\"").append(parameter.getName()).append("\", this.").append(parameter.getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
            this.content.append("    String outputWithCallBack = ictx.getExecutionBuffer().substring(executionIndex);").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("    ictx.getReporter().loopFinished(loop, outputWithCallBack, ictx, parameterValues);").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.append("    ictx.clearBuffer();}").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("return loop;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
    }

    private String getParameterListName(PatternParameter parameter) {
        return String.valueOf(parameter.getName()) + "List";
    }

    private void appendQueryCode(StringBuilder localContent, PatternParameter parameter) throws PatternException {
        Query query = parameter.getQuery();
        if (query == null) {
            localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
            localContent.append("//this pattern can only be called by another (i.e. it's not an entry point in execution)").append(EGFCommonConstants.LINE_SEPARATOR);
            return;
        }
        localContent.append("paramDesc = new IQuery.ParameterDescription(\"").append(parameter.getName()).append("\", \"").append(parameter.getType()).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
        localContent.append("queryCtx = new HashMap<String, String>();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (query.getQueryContext() != null) {
            for (String key : query.getQueryContext().keySet()) {
                localContent.append("queryCtx.put(\"").append(key).append("\", \"").append((String)query.getQueryContext().get((Object)key)).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = ");
        localContent.append("QueryHelper.load(ctx, \"").append(query.getExtensionId()).append("\").execute(paramDesc, queryCtx, ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
    }
}

