/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.tools.ui.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.actions.CreateFcoreHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CreateFcoreAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart targetPart;
    private static final String RESOURCE_CREATE_ID = "org.eclipse.egf.portfolio.genchain.tools.contribution.action.generationchain.resource.createFC";
    private static final String RESOURCE_CREATE_RUN_ID = "org.eclipse.egf.portfolio.genchain.tools.contribution.action.generationchain.resource.createrunFC";
    private static final String OBJECT_CREATE_ID = "org.eclipse.egf.portfolio.genchain.tools.contribution.action.generationchain.object.createFC";
    private static final String OBJECT_CREATE_RUN_ID = "org.eclipse.egf.portfolio.genchain.tools.contribution.action.generationchain.object.createrunFC";

    public void run(IAction action) {
        if (RESOURCE_CREATE_ID.equals(action.getId())) {
            this.createResource(false);
        } else if (RESOURCE_CREATE_RUN_ID.equals(action.getId())) {
            this.createResource(true);
        } else if (OBJECT_CREATE_ID.equals(action.getId())) {
            this.createObject(false);
        } else if (OBJECT_CREATE_RUN_ID.equals(action.getId())) {
            this.createObject(true);
        }
    }

    protected void createObject(boolean run) {
        GenerationChain generationChain = (GenerationChain)this.selection.getFirstElement();
        URI modelResourceURI = generationChain.eResource().getURI();
        IFile modelResourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(modelResourceURI.toPlatformString(true)));
        this.convertProject(modelResourceFile.getProject());
        CreateFcoreHelper.INSTANCE.createJob(generationChain, run).schedule();
    }

    protected void createResource(boolean run) {
        IFile modelFile = (IFile)this.selection.getFirstElement();
        URI modelURI = URI.createPlatformPluginURI((String)modelFile.getFullPath().toString(), (boolean)false);
        this.convertProject(modelFile.getProject());
        CreateFcoreHelper.INSTANCE.createJob(modelURI, run).schedule();
    }

    protected void convertProject(IProject project) {
        ConvertProjectOperation convertOperation = new ConvertProjectOperation(project, false, false);
        try {
            new ProgressMonitorDialog(this.targetPart.getSite().getShell()).run(false, false, (IRunnableWithProgress)convertOperation);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
        if (this.selection == null || this.selection.size() != 1) {
            action.setEnabled(false);
            return;
        }
        if (OBJECT_CREATE_ID.equals(action.getId()) || OBJECT_CREATE_RUN_ID.equals(action.getId())) {
            GenerationChain generationChain = (GenerationChain)this.selection.getFirstElement();
            action.setEnabled(generationChain.getContainer() == null);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

